/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class UserRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/user-tests/";
    }

    @Test
    public void createUserTest() throws Exception {
        String username = "createuser1";
        User user = new User();
        user.setId("createuser1");
        user.setOrganizationId("DEFAULT");
        user.setCreatedAt(new Date());
        user.setUpdatedAt(user.getCreatedAt());
        user.setEmail(String.format("%s@gravitee.io", username));
        user.setStatus(UserStatus.ACTIVE);
        user.setSource("gravitee");
        user.setSourceId("createuser1");
        user.setLoginCount(123L);
        user.setFirstConnectionAt(new Date(1439052010883L));
        user.setNewsletterSubscribed(Boolean.valueOf(false));
        User userCreated = (User)this.userRepository.create((Object)user);
        Assert.assertNotNull((String)"User created is null", (Object)userCreated);
        Optional optional = this.userRepository.findBySource("gravitee", "createuser1", "DEFAULT");
        Assert.assertTrue((String)"Unable to find saved user", (boolean)optional.isPresent());
        User userFound = (User)optional.get();
        Assert.assertEquals((String)"Invalid saved organization id.", (Object)user.getOrganizationId(), (Object)userFound.getOrganizationId());
        Assert.assertEquals((String)"Invalid saved user name.", (Object)user.getId(), (Object)userFound.getId());
        Assert.assertEquals((String)"Invalid saved user mail.", (Object)user.getEmail(), (Object)userFound.getEmail());
        Assert.assertEquals((String)"Invalid saved user status.", (Object)user.getStatus(), (Object)userFound.getStatus());
        Assert.assertEquals((String)"Invalid saved user login count.", (long)user.getLoginCount(), (long)userFound.getLoginCount());
        Assert.assertEquals((String)"Invalid saved user first connection at.", (Object)user.getFirstConnectionAt(), (Object)userFound.getFirstConnectionAt());
        Assert.assertEquals((String)"Invalid saved user newsletter.", (Object)user.getNewsletterSubscribed(), (Object)false);
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.userRepository.findById((Object)"id2update");
        Assert.assertTrue((String)"userRepository to update not found", (boolean)optional.isPresent());
        User user = (User)optional.get();
        user.setSource("sourceUpdated");
        user.setOrganizationId("new_DEFAULT");
        user.setSourceId("sourceIdUpdated");
        user.setPassword("passwordUpdated");
        user.setEmail("emailUpdated");
        user.setFirstname("firstnameUpdated");
        user.setLastname("lastnameUpdated");
        user.setPicture("pictureUpdated");
        user.setStatus(UserStatus.ARCHIVED);
        user.setCreatedAt(new Date(1439032010883L));
        user.setUpdatedAt(new Date(1439042010883L));
        user.setLastConnectionAt(new Date(1439052010883L));
        user.setLoginCount(123L);
        user.setNewsletterSubscribed(Boolean.valueOf(true));
        user.setFirstConnectionAt(new Date(1439052010883L));
        long nbUsersBeforeUpdate = this.userRepository.search(null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getTotalElements();
        this.userRepository.update((Object)user);
        long nbUsersAfterUpdate = this.userRepository.search(null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getTotalElements();
        Assert.assertEquals((long)nbUsersBeforeUpdate, (long)nbUsersAfterUpdate);
        Optional optionalUpdated = this.userRepository.findById((Object)"id2update");
        Assert.assertTrue((String)"User to update not found", (boolean)optionalUpdated.isPresent());
        User userUpdated = (User)optionalUpdated.get();
        Assert.assertEquals((String)"Invalid saved organization id.", (Object)"new_DEFAULT", (Object)userUpdated.getOrganizationId());
        Assert.assertEquals((String)"Invalid saved source", (Object)"sourceUpdated", (Object)userUpdated.getSource());
        Assert.assertEquals((String)"Invalid saved sourceId", (Object)"sourceIdUpdated", (Object)userUpdated.getSourceId());
        Assert.assertEquals((String)"Invalid saved password", (Object)"passwordUpdated", (Object)userUpdated.getPassword());
        Assert.assertEquals((String)"Invalid saved email", (Object)"emailUpdated", (Object)userUpdated.getEmail());
        Assert.assertEquals((String)"Invalid saved firstname", (Object)"firstnameUpdated", (Object)userUpdated.getFirstname());
        Assert.assertEquals((String)"Invalid saved lastname", (Object)"lastnameUpdated", (Object)userUpdated.getLastname());
        Assert.assertEquals((String)"Invalid saved picture", (Object)"pictureUpdated", (Object)userUpdated.getPicture());
        Assert.assertTrue((String)"Invalid saved createDate", (boolean)DateUtils.compareDate(new Date(1439032010883L), userUpdated.getCreatedAt()));
        Assert.assertTrue((String)"Invalid saved updateDate", (boolean)DateUtils.compareDate(new Date(1439042010883L), userUpdated.getUpdatedAt()));
        Assert.assertTrue((String)"Invalid saved lastConnection", (boolean)DateUtils.compareDate(new Date(1439052010883L), userUpdated.getLastConnectionAt()));
        Assert.assertEquals((String)"Invalid status", (Object)UserStatus.ARCHIVED, (Object)userUpdated.getStatus());
        Assert.assertEquals((String)"Invalid saved user login count.", (long)123L, (long)userUpdated.getLoginCount());
        Assert.assertEquals((String)"Invalid saved user newsletter subscribed", (Object)true, (Object)userUpdated.getNewsletterSubscribed());
        Assert.assertEquals((String)"Invalid saved user first connection at.", (Object)user.getFirstConnectionAt(), (Object)userUpdated.getFirstConnectionAt());
    }

    @Test
    public void shouldSearchAllWithEnvironment() throws Exception {
        List users = this.userRepository.search(new UserCriteria.Builder().organizationId("DEFAULT").build(), new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((String)"Invalid user numbers in search", (long)1L, (long)users.size());
        Assert.assertEquals((Object)"user0", (Object)((User)users.get(0)).getId());
    }

    @Test
    public void shouldSearchAllWithNullCriteria() throws Exception {
        List users = this.userRepository.search(null, new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((String)"Invalid user numbers in search", (long)9L, (long)users.size());
        Assert.assertEquals((Object)"user0", (Object)((User)users.get(0)).getId());
        Assert.assertEquals((Object)"user1", (Object)((User)users.get(1)).getId());
        Assert.assertEquals((Object)"user3", (Object)((User)users.get(2)).getId());
        Assert.assertEquals((Object)"user5", (Object)((User)users.get(3)).getId());
        Assert.assertEquals((Object)"user2", (Object)((User)users.get(4)).getId());
        Assert.assertEquals((Object)"user4", (Object)((User)users.get(5)).getId());
        Assert.assertEquals((Object)"id2update", (Object)((User)users.get(6)).getId());
        Assert.assertEquals((Object)"idSpecialChar", (Object)((User)users.get(7)).getId());
        Assert.assertEquals((Object)"user2delete", (Object)((User)users.get(8)).getId());
    }

    @Test
    public void shouldSearchAllWithEmptyCriteria() throws Exception {
        List users = this.userRepository.search(new UserCriteria.Builder().build(), new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
    }

    @Test
    public void shouldSearchArchivedUsers() throws Exception {
        List users = this.userRepository.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ARCHIVED}).build(), new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((String)"Invalid user numbers in find archived", (long)1L, (long)users.size());
    }

    @Test
    public void findUserBySourceCaseInsensitive() throws Exception {
        Optional user1 = this.userRepository.findBySource("gravitee", "user1", "DEV");
        Optional user1Upper = this.userRepository.findBySource("gravitee", "USER1", "DEV");
        Assert.assertTrue((boolean)user1.isPresent());
        Assert.assertTrue((boolean)user1Upper.isPresent());
        Assert.assertEquals((Object)((User)user1.get()).getId(), (Object)((User)user1Upper.get()).getId());
    }

    @Test
    public void findUserByEmail() throws Exception {
        Optional user1 = this.userRepository.findByEmail("user0@gravitee.io", "DEFAULT");
        Optional user1Upper = this.userRepository.findByEmail("usER0@gravitee.io", "DEFAULT");
        Assert.assertTrue((boolean)user1.isPresent());
        Assert.assertTrue((boolean)user1Upper.isPresent());
        Assert.assertEquals((Object)((User)user1.get()).getId(), (Object)((User)user1Upper.get()).getId());
    }

    @Test
    public void findUserBySourceSpecialCharacters() throws Exception {
        Optional user = this.userRepository.findBySource("sourceSpecialChar", "sourceIdSpecialChar+test@me", "DEV");
        Assert.assertTrue((boolean)user.isPresent());
    }

    @Test
    public void shouldSearchUsersWithNoStatus() throws Exception {
        List users = this.userRepository.search(new UserCriteria.Builder().noStatus().build(), new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((String)"Invalid user numbers in find no status", (long)1L, (long)users.size());
    }

    @Test
    public void shouldSearchActiveUsers() throws Exception {
        List users = this.userRepository.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE}).build(), new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build()).getContent();
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((String)"Invalid user numbers in find active", (long)7L, (long)users.size());
    }

    @Test
    public void findUserBySourceTest() throws Exception {
        Optional user = this.userRepository.findBySource("gravitee", "user1", "DEV");
        Assert.assertTrue((boolean)user.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownUser() throws Exception {
        User unknownUser = new User();
        unknownUser.setId("unknown");
        this.userRepository.update((Object)unknownUser);
        Assert.fail((String)"An unknown user should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.userRepository.update(null);
        Assert.fail((String)"A null user should not be updated");
    }

    @Test
    public void shouldFindById() throws Exception {
        Optional optionalUser = this.userRepository.findById((Object)"user1");
        Assert.assertTrue((boolean)optionalUser.isPresent());
        Assert.assertEquals((String)"User not found by its id", (Object)"user1", (Object)((User)optionalUser.get()).getId());
    }

    @Test
    public void shouldFindByIds() throws Exception {
        Set users = this.userRepository.findByIds(Arrays.asList("user1", "user5"));
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertTrue((boolean)users.stream().map(User::getId).collect(Collectors.toList()).containsAll(Arrays.asList("user1", "user5")));
    }

    @Test
    public void shouldDelete() throws Exception {
        Assert.assertTrue((String)"user2delete exists", (boolean)this.userRepository.findById((Object)"user2delete").isPresent());
        this.userRepository.delete((Object)"user2delete");
        Assert.assertFalse((String)"user2delete not exists", (boolean)this.userRepository.findById((Object)"user2delete").isPresent());
    }
}

