/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository;

import io.gravitee.repository.config.AbstractRepositoryTest;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.repository.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class WorkflowRepositoryTest
extends AbstractRepositoryTest {
    @Override
    protected String getTestCasesPath() {
        return "/data/workflow-tests/";
    }

    @Test
    public void shouldFindAll() throws Exception {
        Set workflows = this.workflowRepository.findAll();
        Assert.assertNotNull((Object)workflows);
        Assert.assertEquals((long)4L, (long)workflows.size());
        Optional<Workflow> optionalWorkflow = workflows.stream().filter(workflow -> "old-workflow".equals(workflow.getId())).findAny();
        Assert.assertTrue((boolean)optionalWorkflow.isPresent());
        Assert.assertEquals((Object)"API", (Object)optionalWorkflow.get().getReferenceType());
        Assert.assertEquals((Object)"api-id", (Object)optionalWorkflow.get().getReferenceId());
        Assert.assertEquals((Object)"REVIEW", (Object)optionalWorkflow.get().getType());
        Assert.assertEquals((Object)"DRAFT", (Object)optionalWorkflow.get().getState());
        Assert.assertEquals((Object)"User", (Object)optionalWorkflow.get().getUser());
        Assert.assertEquals((Object)"Comment", (Object)optionalWorkflow.get().getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(1518357357000L, optionalWorkflow.get().getCreatedAt().getTime()));
    }

    @Test
    public void shouldCreate() throws Exception {
        Workflow workflow = new Workflow();
        workflow.setId("new-workflow");
        workflow.setReferenceType("API");
        workflow.setReferenceId("api-id");
        workflow.setType("REVIEW");
        workflow.setState("DRAFT");
        workflow.setComment("test");
        workflow.setCreatedAt(new Date(1439022010883L));
        int nbWorkflowsBeforeCreation = this.workflowRepository.findAll().size();
        this.workflowRepository.create((Object)workflow);
        int nbWorkflowsAfterCreation = this.workflowRepository.findAll().size();
        Assert.assertEquals((long)(nbWorkflowsBeforeCreation + 1), (long)nbWorkflowsAfterCreation);
        Optional optional = this.workflowRepository.findById((Object)"new-workflow");
        Assert.assertTrue((String)"Workflow saved not found", (boolean)optional.isPresent());
        Workflow fetchedWorkflow = (Workflow)optional.get();
        Assert.assertEquals((Object)workflow.getReferenceType(), (Object)fetchedWorkflow.getReferenceType());
        Assert.assertEquals((Object)workflow.getReferenceId(), (Object)fetchedWorkflow.getReferenceId());
        Assert.assertEquals((Object)workflow.getType(), (Object)fetchedWorkflow.getType());
        Assert.assertEquals((Object)workflow.getState(), (Object)fetchedWorkflow.getState());
        Assert.assertEquals((Object)workflow.getComment(), (Object)fetchedWorkflow.getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(workflow.getCreatedAt(), fetchedWorkflow.getCreatedAt()));
    }

    @Test
    public void shouldUpdate() throws Exception {
        Optional optional = this.workflowRepository.findById((Object)"workflow");
        Assert.assertTrue((String)"Workflow to update not found", (boolean)optional.isPresent());
        Workflow workflow = (Workflow)optional.get();
        workflow.setReferenceType("New reference type");
        workflow.setReferenceId("New reference id");
        workflow.setType("New type");
        workflow.setState("IN_REVIEW");
        workflow.setComment("New comment");
        Date date = new Date(1439022010883L);
        workflow.setCreatedAt(date);
        int nbWorkflowsBeforeUpdate = this.workflowRepository.findAll().size();
        this.workflowRepository.update((Object)workflow);
        int nbWorkflowsAfterUpdate = this.workflowRepository.findAll().size();
        Assert.assertEquals((long)nbWorkflowsBeforeUpdate, (long)nbWorkflowsAfterUpdate);
        Optional optionalUpdated = this.workflowRepository.findById((Object)"workflow");
        Assert.assertTrue((String)"Workflow to update not found", (boolean)optionalUpdated.isPresent());
        Workflow fetchedWorkflow = (Workflow)optionalUpdated.get();
        Assert.assertEquals((Object)workflow.getReferenceType(), (Object)fetchedWorkflow.getReferenceType());
        Assert.assertEquals((Object)workflow.getReferenceId(), (Object)fetchedWorkflow.getReferenceId());
        Assert.assertEquals((Object)workflow.getType(), (Object)fetchedWorkflow.getType());
        Assert.assertEquals((Object)workflow.getState(), (Object)fetchedWorkflow.getState());
        Assert.assertEquals((Object)workflow.getComment(), (Object)fetchedWorkflow.getComment());
        Assert.assertTrue((boolean)DateUtils.compareDate(workflow.getCreatedAt(), fetchedWorkflow.getCreatedAt()));
    }

    @Test
    public void shouldDelete() throws Exception {
        int nbWorkflowsBeforeDeletion = this.workflowRepository.findAll().size();
        this.workflowRepository.delete((Object)"workflow");
        int nbWorkflowsAfterDeletion = this.workflowRepository.findAll().size();
        Assert.assertEquals((long)(nbWorkflowsBeforeDeletion - 1), (long)nbWorkflowsAfterDeletion);
    }

    @Test
    public void shouldFindByReferenceAndType() throws Exception {
        List workflows = this.workflowRepository.findByReferenceAndType("API", "api-id", "REVIEW");
        Assert.assertNotNull((Object)workflows);
        Assert.assertEquals((long)3L, (long)workflows.size());
        Assert.assertEquals((Object)"workflow", (Object)((Workflow)workflows.get(0)).getId());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateUnknownWorkflow() throws Exception {
        Workflow unknownWorkflow = new Workflow();
        unknownWorkflow.setId("unknown");
        this.workflowRepository.update((Object)unknownWorkflow);
        Assert.fail((String)"An unknown workflow should not be updated");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotUpdateNull() throws Exception {
        this.workflowRepository.update(null);
        Assert.fail((String)"A null workflow should not be updated");
    }
}

