/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config;

import io.gravitee.repository.config.PropertySourceRepositoryInitializer;
import io.gravitee.repository.config.TestRepositoryInitializer;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AlertEventRepository;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.repository.management.api.ApiHeaderRepository;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.api.ClientRegistrationProviderRepository;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.CustomUserFieldsRepository;
import io.gravitee.repository.management.api.DashboardRepository;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.api.EntrypointRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.IdentityProviderActivationRepository;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.api.InstallationRepository;
import io.gravitee.repository.management.api.InvitationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.api.NotificationTemplateRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.PageRevisionRepository;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.api.PortalNotificationRepository;
import io.gravitee.repository.management.api.QualityRuleRepository;
import io.gravitee.repository.management.api.RatingAnswerRepository;
import io.gravitee.repository.management.api.RatingRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.TagRepository;
import io.gravitee.repository.management.api.TenantRepository;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.api.TicketRepository;
import io.gravitee.repository.management.api.TokenRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.WorkflowRepository;
import io.gravitee.repository.management.model.AlertEvent;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiHeader;
import io.gravitee.repository.management.model.ApiKey;
import io.gravitee.repository.management.model.ApiQualityRule;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Category;
import io.gravitee.repository.management.model.ClientRegistrationProvider;
import io.gravitee.repository.management.model.Command;
import io.gravitee.repository.management.model.CustomUserField;
import io.gravitee.repository.management.model.Dashboard;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.Entrypoint;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.IdentityProviderActivation;
import io.gravitee.repository.management.model.Installation;
import io.gravitee.repository.management.model.Invitation;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.NotificationTemplate;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageRevision;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.PortalNotification;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.repository.management.model.QualityRule;
import io.gravitee.repository.management.model.Rating;
import io.gravitee.repository.management.model.RatingAnswer;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.repository.management.model.Tag;
import io.gravitee.repository.management.model.Tenant;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.repository.management.model.Ticket;
import io.gravitee.repository.management.model.Token;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.repository.media.api.MediaRepository;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.util.StringUtils;

@RunWith(value=SpringJUnit4ClassRunner.class)
@org.springframework.test.context.ContextConfiguration(loader=AnnotationConfigContextLoader.class, initializers={PropertySourceRepositoryInitializer.class})
@ActiveProfiles(value={"test"})
public abstract class AbstractRepositoryTest {
    private static final String MODEL_PACKAGE = "io.gravitee.repository.management.model.";
    private static final String JSON_EXTENSION = "json";
    @Inject
    private TestRepositoryInitializer testRepositoryInitializer;
    @Inject
    protected ApplicationRepository applicationRepository;
    @Inject
    protected ApiRepository apiRepository;
    @Inject
    protected UserRepository userRepository;
    @Inject
    protected ApiKeyRepository apiKeyRepository;
    @Inject
    protected EventRepository eventRepository;
    @Inject
    protected CategoryRepository categoryRepository;
    @Inject
    protected GroupRepository groupRepository;
    @Inject
    protected MembershipRepository membershipRepository;
    @Inject
    protected PlanRepository planRepository;
    @Inject
    protected TagRepository tagRepository;
    @Inject
    protected PageRepository pageRepository;
    @Inject
    protected PageRevisionRepository pageRevisionRepository;
    @Inject
    protected SubscriptionRepository subscriptionRepository;
    @Inject
    protected TenantRepository tenantRepository;
    @Inject
    protected MetadataRepository metadataRepository;
    @Inject
    protected RoleRepository roleRepository;
    @Inject
    protected AuditRepository auditRepository;
    @Inject
    protected RatingRepository ratingRepository;
    @Inject
    protected RatingAnswerRepository ratingAnswerRepository;
    @Inject
    protected PortalNotificationRepository portalNotificationRepository;
    @Inject
    protected PortalNotificationConfigRepository portalNotificationConfigRepository;
    @Inject
    protected GenericNotificationConfigRepository genericNotificationConfigRepository;
    @Inject
    protected ParameterRepository parameterRepository;
    @Inject
    protected DictionaryRepository dictionaryRepository;
    @Inject
    protected ApiHeaderRepository apiHeaderRepository;
    @Inject
    protected CommandRepository commandRepository;
    @Inject
    protected MediaRepository mediaRepository;
    @Inject
    protected IdentityProviderRepository identityProviderRepository;
    @Inject
    protected AlertTriggerRepository alertRepository;
    @Inject
    protected EntrypointRepository entrypointRepository;
    @Inject
    protected InvitationRepository invitationRepository;
    @Inject
    protected ClientRegistrationProviderRepository clientRegistrationProviderRepository;
    @Inject
    protected WorkflowRepository workflowRepository;
    @Inject
    protected QualityRuleRepository qualityRuleRepository;
    @Inject
    protected ApiQualityRuleRepository apiQualityRuleRepository;
    @Inject
    protected DashboardRepository dashboardRepository;
    @Inject
    protected AlertEventRepository alertEventRepository;
    @Inject
    protected EnvironmentRepository environmentRepository;
    @Inject
    protected OrganizationRepository organizationRepository;
    @Inject
    protected ThemeRepository themeRepository;
    @Inject
    protected TokenRepository tokenRepository;
    @Inject
    protected CustomUserFieldsRepository customUserFieldsRepository;
    @Inject
    protected IdentityProviderActivationRepository identityProviderActivationRepository;
    @Inject
    protected NotificationTemplateRepository notificationTemplateRepository;
    @Inject
    protected TicketRepository ticketRepository;
    @Inject
    protected InstallationRepository installationRepository;
    private ObjectMapper mapper = new ObjectMapper();

    protected abstract String getTestCasesPath();

    @Before
    public void setUp() throws Exception {
        this.testRepositoryInitializer.setUp();
        File file = new File(AbstractRepositoryTest.class.getResource(this.getTestCasesPath()).toURI());
        File[] collectionsDumps = file.listFiles(pathname -> pathname.isFile() && JSON_EXTENSION.equalsIgnoreCase(FilenameUtils.getExtension((String)pathname.toString())));
        for (File collectionsDump : Arrays.asList(collectionsDumps).stream().sorted((o1, o2) -> o2.getName().compareTo(o1.getName())).collect(Collectors.toList())) {
            Class c = this.getClassFromFileName(FilenameUtils.getBaseName((String)collectionsDump.getName()));
            for (Object object : this.mapToModel(collectionsDump, c)) {
                this.createModel(object);
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        this.testRepositoryInitializer.tearDown();
    }

    private void createModel(Object object) throws TechnicalException {
        if (object instanceof Application) {
            this.applicationRepository.create((Object)((Application)object));
        } else if (object instanceof Api) {
            this.apiRepository.create((Object)((Api)object));
        } else if (object instanceof User) {
            this.userRepository.create((Object)((User)object));
        } else if (object instanceof Event) {
            this.eventRepository.create((Object)((Event)object));
        } else if (object instanceof ApiKey) {
            ApiKey apiKey = (ApiKey)object;
            this.apiKeyRepository.create(apiKey);
        } else if (object instanceof Category) {
            this.categoryRepository.create((Category)object);
        } else if (object instanceof Group) {
            this.groupRepository.create((Object)((Group)object));
        } else if (object instanceof Membership) {
            this.membershipRepository.create((Membership)object);
        } else if (object instanceof Plan) {
            this.planRepository.create((Object)((Plan)object));
        } else if (object instanceof Tag) {
            this.tagRepository.create((Object)((Tag)object));
        } else if (object instanceof Page) {
            this.pageRepository.create((Page)object);
        } else if (object instanceof Subscription) {
            this.subscriptionRepository.create((Object)((Subscription)object));
        } else if (object instanceof Tenant) {
            this.tenantRepository.create((Object)((Tenant)object));
        } else if (object instanceof Metadata) {
            this.metadataRepository.create((Metadata)object);
        } else if (object instanceof Role) {
            this.roleRepository.create((Role)object);
        } else if (object instanceof Audit) {
            this.auditRepository.create((Object)((Audit)object));
        } else if (object instanceof Rating) {
            this.ratingRepository.create((Rating)object);
        } else if (object instanceof RatingAnswer) {
            this.ratingAnswerRepository.create((RatingAnswer)object);
        } else if (object instanceof PortalNotification) {
            this.portalNotificationRepository.create((Object)((PortalNotification)object));
        } else if (object instanceof PortalNotificationConfig) {
            this.portalNotificationConfigRepository.create((PortalNotificationConfig)object);
        } else if (object instanceof GenericNotificationConfig) {
            this.genericNotificationConfigRepository.create((GenericNotificationConfig)object);
        } else if (object instanceof Parameter) {
            this.parameterRepository.create((Parameter)object);
        } else if (object instanceof Dictionary) {
            this.dictionaryRepository.create((Object)((Dictionary)object));
        } else if (object instanceof ApiHeader) {
            this.apiHeaderRepository.create((Object)((ApiHeader)object));
        } else if (object instanceof Command) {
            this.commandRepository.create((Object)((Command)object));
        } else if (object instanceof IdentityProvider) {
            this.identityProviderRepository.create((IdentityProvider)object);
        } else if (object instanceof AlertTrigger) {
            this.alertRepository.create((Object)((AlertTrigger)object));
        } else if (object instanceof Entrypoint) {
            this.entrypointRepository.create((Object)((Entrypoint)object));
        } else if (object instanceof Invitation) {
            this.invitationRepository.create((Object)((Invitation)object));
        } else if (object instanceof ClientRegistrationProvider) {
            this.clientRegistrationProviderRepository.create((Object)((ClientRegistrationProvider)object));
        } else if (object instanceof Workflow) {
            this.workflowRepository.create((Object)((Workflow)object));
        } else if (object instanceof QualityRule) {
            this.qualityRuleRepository.create((Object)((QualityRule)object));
        } else if (object instanceof ApiQualityRule) {
            this.apiQualityRuleRepository.create((ApiQualityRule)object);
        } else if (object instanceof Dashboard) {
            this.dashboardRepository.create((Object)((Dashboard)object));
        } else if (object instanceof AlertEvent) {
            this.alertEventRepository.create((Object)((AlertEvent)object));
        } else if (object instanceof Environment) {
            this.environmentRepository.create((Object)((Environment)object));
        } else if (object instanceof Organization) {
            this.organizationRepository.create((Object)((Organization)object));
        } else if (object instanceof Theme) {
            this.themeRepository.create((Object)((Theme)object));
        } else if (object instanceof IdentityProviderActivation) {
            this.identityProviderActivationRepository.create((IdentityProviderActivation)object);
        } else if (object instanceof Token) {
            this.tokenRepository.create((Object)((Token)object));
        } else if (object instanceof PageRevision) {
            this.pageRevisionRepository.create((PageRevision)object);
        } else if (object instanceof CustomUserField) {
            this.customUserFieldsRepository.create((CustomUserField)object);
        } else if (object instanceof NotificationTemplate) {
            this.notificationTemplateRepository.create((NotificationTemplate)object);
        } else if (object instanceof Ticket) {
            this.ticketRepository.create((Ticket)object);
        } else if (object instanceof Installation) {
            this.installationRepository.create((Object)((Installation)object));
        }
    }

    private Class getClassFromFileName(String baseName) {
        String className = StringUtils.capitalize((String)baseName.substring(0, baseName.length() - 1));
        try {
            return Class.forName(MODEL_PACKAGE + className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The entity can not be found for " + className, e);
        }
    }

    protected <T> List<T> mapToModel(File file, Class<T> clazz) throws Exception {
        return (List)this.mapper.readValue(file, TypeFactory.collectionType(List.class, clazz));
    }

    @Configuration
    @ComponentScan(value={"io.gravitee.repository"}, includeFilters={@ComponentScan.Filter(pattern={".*Test.*"}, type=FilterType.REGEX)}, useDefaultFilters=false)
    static class ContextConfiguration {
        ContextConfiguration() {
        }
    }
}

