/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;

public class PropertySourceRepositoryInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Logger logger = LoggerFactory.getLogger(PropertySourceRepositoryInitializer.class);
    private static final String REPOSITORY_PROPERTY_SOURCE = "repository.properties";

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment environment = configurableApplicationContext.getEnvironment();
        try {
            this.logger.info("Trying to load a repository properties file from classpath: repository.properties");
            ResourcePropertySource source = new ResourcePropertySource("repository", (Resource)new ClassPathResource(REPOSITORY_PROPERTY_SOURCE));
            MutablePropertySources sources = environment.getPropertySources();
            sources.addFirst((PropertySource)source);
            this.logger.info("Repository properties file has been correctly added to environment");
        }
        catch (Exception ex) {
            this.logger.error("Unable to load repository properties file into environment", (Throwable)ex);
        }
    }
}

