/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.AlertEventRepository;
import io.gravitee.repository.management.api.search.AlertEventCriteria;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.AlertEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AlertEventRepositoryMock
extends AbstractRepositoryMock<AlertEventRepository> {
    public AlertEventRepositoryMock() {
        super(AlertEventRepository.class);
    }

    @Override
    void prepare(AlertEventRepository alertEventRepository) throws Exception {
        Date date = new Date(1439022010883L);
        AlertEvent alertEvent = new AlertEvent();
        alertEvent.setId("new-alert-event");
        alertEvent.setAlert("1111-2222-3333-4444");
        alertEvent.setMessage("an alert message");
        alertEvent.setCreatedAt(date);
        alertEvent.setUpdatedAt(date);
        AlertEvent alertBeforeUpdate = new AlertEvent();
        alertBeforeUpdate.setId("an-alert-to-update");
        alertBeforeUpdate.setAlert("alert-parent-id");
        alertBeforeUpdate.setMessage("Message of the alert to update");
        alertBeforeUpdate.setCreatedAt(date);
        alertBeforeUpdate.setUpdatedAt(date);
        AlertEvent alert2Updated = new AlertEvent();
        alert2Updated.setId("an-alert-to-update");
        alert2Updated.setAlert("alert-parent-id");
        alert2Updated.setMessage("An updated message");
        alert2Updated.setCreatedAt(date);
        alert2Updated.setUpdatedAt(date);
        AlertEvent alertLatest = new AlertEvent();
        alertLatest.setId("latest-alert");
        alertLatest.setAlert("alert-parent-id2");
        alertLatest.setMessage("Message of the latest alert");
        alertLatest.setCreatedAt(date);
        alertLatest.setUpdatedAt(date);
        Page pageAlertEvent = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)pageAlertEvent.getTotalElements()).thenReturn((Object)3L);
        Mockito.when((Object)pageAlertEvent.getContent()).thenReturn(Arrays.asList(alertEvent, alertBeforeUpdate, alertLatest));
        Page pageAlertEvent2 = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)pageAlertEvent2.getTotalElements()).thenReturn((Object)2L);
        Mockito.when((Object)pageAlertEvent2.getContent()).thenReturn(Arrays.asList(alertEvent, alertLatest));
        Page pageAlertEvent3 = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)pageAlertEvent3.getTotalElements()).thenReturn((Object)1L);
        Mockito.when((Object)pageAlertEvent3.getContent()).thenReturn(Arrays.asList(alertLatest));
        Page pageAlertEventEmpty = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)pageAlertEventEmpty.getTotalElements()).thenReturn((Object)0L);
        Mockito.when((Object)pageAlertEventEmpty.getContent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)alertEventRepository.search((AlertEventCriteria)Matchers.argThat(o -> o != null && o.getAlert() == null), (Pageable)Matchers.any(Pageable.class))).thenReturn((Object)pageAlertEvent, (Object[])new Page[]{pageAlertEvent2, pageAlertEvent3});
        Mockito.when((Object)alertEventRepository.search((AlertEventCriteria)Matchers.argThat(o -> o != null && "alert-parent-id2".equals(o.getAlert())), (Pageable)Matchers.any(Pageable.class))).thenReturn((Object)pageAlertEvent3);
        Mockito.when((Object)alertEventRepository.search((AlertEventCriteria)Matchers.argThat(o -> o != null && "alert-id-to-delete".equals(o.getAlert())), (Pageable)Matchers.any(Pageable.class))).thenReturn((Object)pageAlertEvent2, (Object[])new Page[]{pageAlertEventEmpty});
        Mockito.when((Object)alertEventRepository.create(Matchers.any(AlertEvent.class))).thenReturn((Object)alertEvent);
        Mockito.when((Object)alertEventRepository.findById((Object)"new-alert-event")).thenReturn(Optional.of(alertEvent));
        Mockito.when((Object)alertEventRepository.findById((Object)"an-alert-to-update")).thenReturn(Optional.of(alertBeforeUpdate), (Object[])new Optional[]{Optional.of(alert2Updated)});
        Mockito.when((Object)alertEventRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

