/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.repository.management.model.AlertEventRule;
import io.gravitee.repository.management.model.AlertEventType;
import io.gravitee.repository.management.model.AlertTrigger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class AlertTriggerRepositoryMock
extends AbstractRepositoryMock<AlertTriggerRepository> {
    public AlertTriggerRepositoryMock() {
        super(AlertTriggerRepository.class);
    }

    @Override
    void prepare(AlertTriggerRepository alertRepository) throws Exception {
        Date date = new Date(1439022010883L);
        AlertTrigger alert = new AlertTrigger();
        alert.setId("new-alert");
        alert.setName("Alert name");
        alert.setDescription("Description for the new alert");
        alert.setReferenceType("API");
        alert.setReferenceId("api-id");
        alert.setType("HEALTH_CHECK");
        alert.setDefinition("{}");
        alert.setCreatedAt(date);
        alert.setUpdatedAt(date);
        AlertTrigger alert2 = new AlertTrigger();
        alert2.setId("alert");
        alert2.setName("Health-check");
        AlertTrigger alertBeforeUpdate = new AlertTrigger();
        alertBeforeUpdate.setId("quota80");
        alertBeforeUpdate.setName("Quota80");
        AlertTrigger alert2Updated = new AlertTrigger();
        alert2Updated.setId("quota80");
        alert2Updated.setName("New name");
        alert2Updated.setDescription("New description");
        alert2Updated.setReferenceType("New reference type");
        alert2Updated.setReferenceId("New reference id");
        alert2Updated.setType("New type");
        alert2Updated.setDefinition("{}");
        alert2Updated.setEnabled(true);
        alert2Updated.setCreatedAt(date);
        alert2Updated.setUpdatedAt(date);
        AlertTrigger alertQuota = new AlertTrigger();
        alertQuota.setId("quota90");
        alertQuota.setName("Quota90");
        alertQuota.setDescription("Description for alert API quota 90%");
        alertQuota.setReferenceType("APPLICATION");
        alertQuota.setReferenceId("application-id");
        alertQuota.setType("QUOTA");
        alertQuota.setDefinition("{}");
        alertQuota.setEnabled(true);
        alertQuota.setCreatedAt(date);
        alertQuota.setUpdatedAt(new Date(1439022010883L));
        alertQuota.setTemplate(true);
        alertQuota.setEventRules(Collections.singletonList(new AlertEventRule()));
        AlertTrigger alertTriggerEvents = new AlertTrigger();
        alertTriggerEvents.setId("health-check");
        alertTriggerEvents.setName("Health-check");
        AlertEventRule eventRule1 = new AlertEventRule();
        eventRule1.setEvent(AlertEventType.API_CREATE);
        alertTriggerEvents.setEventRules(Arrays.asList(eventRule1));
        Set alerts = Sets.newSet((Object[])new AlertTrigger[]{alert, alertQuota, alert2Updated});
        Set alertsAfterDelete = Sets.newSet((Object[])new AlertTrigger[]{alert, alertQuota});
        Set alertsAfterAdd = Sets.newSet((Object[])new AlertTrigger[]{alert, alert2, (AlertTrigger)Mockito.mock(AlertTrigger.class), (AlertTrigger)Mockito.mock(AlertTrigger.class)});
        Mockito.when((Object)alertRepository.findAll()).thenReturn((Object)alerts, (Object[])new Set[]{alertsAfterAdd, alerts, alertsAfterDelete, alerts});
        Mockito.when((Object)alertRepository.create(Matchers.any(AlertTrigger.class))).thenReturn((Object)alert);
        Mockito.when((Object)alertRepository.findById((Object)"health-check")).thenReturn(Optional.of(alertTriggerEvents));
        Mockito.when((Object)alertRepository.findById((Object)"new-alert")).thenReturn(Optional.of(alert));
        Mockito.when((Object)alertRepository.findById((Object)"quota80")).thenReturn(Optional.of(alertBeforeUpdate), (Object[])new Optional[]{Optional.of(alert2Updated)});
        Mockito.when((Object)alertRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)alertRepository.findByReference("API", "api-id")).thenReturn(Collections.singletonList(alert));
    }
}

