/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.search.ApiKeyCriteria;
import io.gravitee.repository.management.model.ApiKey;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class ApiKeyRepositoryMock
extends AbstractRepositoryMock<ApiKeyRepository> {
    public ApiKeyRepositoryMock() {
        super(ApiKeyRepository.class);
    }

    @Override
    void prepare(ApiKeyRepository apiKeyRepository) throws Exception {
        ApiKey apiKey = (ApiKey)Mockito.mock(ApiKey.class);
        Mockito.when((Object)apiKey.getKey()).thenReturn((Object)"apiKey");
        Mockito.when((Object)apiKey.getExpireAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)apiKey.getSubscription()).thenReturn((Object)"subscription1");
        Mockito.when((Object)apiKey.isRevoked()).thenReturn((Object)true);
        Mockito.when((Object)apiKey.isPaused()).thenReturn((Object)true);
        Mockito.when((Object)apiKeyRepository.findById(Matchers.anyString())).thenReturn(Optional.empty());
        Mockito.when((Object)apiKeyRepository.findById("d449098d-8c31-4275-ad59-8dd707865a33")).thenReturn(Optional.of(apiKey));
        Mockito.when((Object)apiKeyRepository.findById("apiKey")).thenReturn(Optional.of(apiKey));
        Mockito.when((Object)apiKeyRepository.findBySubscription("subscription1")).thenReturn((Object)Sets.newSet((Object[])new ApiKey[]{apiKey, (ApiKey)Mockito.mock(ApiKey.class)}));
        Mockito.when((Object)apiKeyRepository.update((ApiKey)Matchers.argThat(o -> o == null || o.getKey().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        ApiKey mockCriteria1 = (ApiKey)Mockito.mock(ApiKey.class);
        ApiKey mockCriteria1Revoked = (ApiKey)Mockito.mock(ApiKey.class);
        ApiKey mockCriteria2 = (ApiKey)Mockito.mock(ApiKey.class);
        Mockito.when((Object)mockCriteria1.getKey()).thenReturn((Object)"findByCriteria1");
        Mockito.when((Object)mockCriteria1Revoked.getKey()).thenReturn((Object)"findByCriteria1Revoked");
        Mockito.when((Object)mockCriteria2.getKey()).thenReturn((Object)"findByCriteria2");
        Mockito.when((Object)apiKeyRepository.findByCriteria((ApiKeyCriteria)Matchers.argThat(o -> o == null || o.getFrom() == 0L))).thenReturn(Arrays.asList(mockCriteria1, mockCriteria2));
        Mockito.when((Object)apiKeyRepository.findByCriteria((ApiKeyCriteria)Matchers.argThat(o -> o == null || o.getTo() == 1486771400000L))).thenReturn(Collections.singletonList(mockCriteria1));
        Mockito.when((Object)apiKeyRepository.findByCriteria((ApiKeyCriteria)Matchers.argThat(o -> o == null || o.isIncludeRevoked()))).thenReturn(Arrays.asList(mockCriteria2, mockCriteria1Revoked, mockCriteria1));
    }
}

