/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class ApiRepositoryMock
extends AbstractRepositoryMock<ApiRepository> {
    public ApiRepositoryMock() {
        super(ApiRepository.class);
    }

    @Override
    void prepare(ApiRepository apiRepository) throws Exception {
        Api apiToDelete = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)apiToDelete.getId()).thenReturn((Object)"api-to-delete");
        Api apiToUpdate = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)apiToUpdate.getId()).thenReturn((Object)"api-to-update");
        Mockito.when((Object)apiToUpdate.getName()).thenReturn((Object)"api-to-update name");
        Mockito.when((Object)apiToUpdate.getApiLifecycleState()).thenReturn((Object)ApiLifecycleState.PUBLISHED);
        Api apiUpdated = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)apiUpdated.getName()).thenReturn((Object)"New API name");
        Mockito.when((Object)apiUpdated.getEnvironmentId()).thenReturn((Object)"new_DEFAULT");
        Mockito.when((Object)apiUpdated.getDescription()).thenReturn((Object)"New description");
        Mockito.when((Object)apiUpdated.getCategories()).thenReturn((Object)Sets.newSet((Object[])new String[]{"category1", "category2"}));
        Mockito.when((Object)apiUpdated.getDefinition()).thenReturn((Object)"New definition");
        Mockito.when((Object)apiUpdated.getDeployedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)apiUpdated.getGroups()).thenReturn(Collections.singleton("New group"));
        Mockito.when((Object)apiUpdated.getLifecycleState()).thenReturn((Object)LifecycleState.STARTED);
        Mockito.when((Object)apiUpdated.getPicture()).thenReturn((Object)"New picture");
        Mockito.when((Object)apiUpdated.getBackground()).thenReturn((Object)"New background");
        Mockito.when((Object)apiUpdated.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)apiUpdated.getUpdatedAt()).thenReturn((Object)DateUtils.parse("13/11/2016"));
        Mockito.when((Object)apiUpdated.getVersion()).thenReturn((Object)"New version");
        Mockito.when((Object)apiUpdated.getVisibility()).thenReturn((Object)Visibility.PRIVATE);
        Mockito.when((Object)apiUpdated.getApiLifecycleState()).thenReturn((Object)ApiLifecycleState.UNPUBLISHED);
        Mockito.when((Object)apiUpdated.isDisableMembershipNotifications()).thenReturn((Object)false);
        Mockito.when((Object)apiRepository.findById((Object)"api-to-update")).thenReturn(Optional.of(apiToUpdate), (Object[])new Optional[]{Optional.of(apiUpdated)});
        Mockito.when((Object)apiRepository.findById((Object)"api-to-delete")).thenReturn(Optional.of(apiToDelete), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)apiRepository.findById((Object)"findByNameMissing")).thenReturn(Optional.empty());
        Api newApi = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)newApi.getId()).thenReturn((Object)"newApi-Id");
        Mockito.when((Object)newApi.getVersion()).thenReturn((Object)"1");
        Mockito.when((Object)newApi.getLifecycleState()).thenReturn((Object)LifecycleState.STOPPED);
        Mockito.when((Object)newApi.getVisibility()).thenReturn((Object)Visibility.PRIVATE);
        Mockito.when((Object)newApi.getDefinition()).thenReturn((Object)"{}");
        Mockito.when((Object)newApi.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)newApi.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)newApi.getUpdatedAt()).thenReturn((Object)DateUtils.parse("12/02/2016"));
        Mockito.when((Object)newApi.getApiLifecycleState()).thenReturn((Object)ApiLifecycleState.CREATED);
        Mockito.when((Object)newApi.isDisableMembershipNotifications()).thenReturn((Object)true);
        Mockito.when((Object)apiRepository.findById((Object)"newApi-Id")).thenReturn(Optional.of(newApi), (Object[])new Optional[]{Optional.empty()});
        Api groupedApi = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)groupedApi.getGroups()).thenReturn(Collections.singleton("api-group"));
        Mockito.when((Object)groupedApi.getId()).thenReturn((Object)"grouped-api");
        Mockito.when((Object)groupedApi.getApiLifecycleState()).thenReturn((Object)ApiLifecycleState.PUBLISHED);
        Mockito.when((Object)apiRepository.findById((Object)"grouped-api")).thenReturn(Optional.of(groupedApi));
        Api apiToFindById = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)apiToFindById.getId()).thenReturn((Object)"api-to-findById");
        Mockito.when((Object)apiToFindById.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)apiToFindById.getVersion()).thenReturn((Object)"1");
        Mockito.when((Object)apiToFindById.getName()).thenReturn((Object)"api-to-findById name");
        Mockito.when((Object)apiToFindById.getLifecycleState()).thenReturn((Object)LifecycleState.STOPPED);
        Mockito.when((Object)apiToFindById.getVisibility()).thenReturn((Object)Visibility.PUBLIC);
        Mockito.when((Object)apiToFindById.getDefinition()).thenReturn(null);
        Mockito.when((Object)apiToFindById.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)apiToFindById.getUpdatedAt()).thenReturn((Object)DateUtils.parse("12/02/2016"));
        Mockito.when((Object)apiToFindById.getLabels()).thenReturn(Arrays.asList("label 1", "label 2"));
        Mockito.when((Object)apiToFindById.getApiLifecycleState()).thenReturn((Object)ApiLifecycleState.DEPRECATED);
        Mockito.when((Object)apiToFindById.isDisableMembershipNotifications()).thenReturn((Object)true);
        Mockito.when((Object)apiRepository.findById((Object)"api-to-findById")).thenReturn(Optional.of(apiToFindById));
        List<Api> searchedApis = Arrays.asList((Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class));
        List<Api> searchedApisAfterDeletion = Arrays.asList((Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class));
        Mockito.when((Object)apiRepository.search(null)).thenReturn(searchedApis, (Object[])new List[]{searchedApis, searchedApis, searchedApisAfterDeletion});
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().build())).thenReturn(Arrays.asList((Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class), (Api)Mockito.mock(Api.class)));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().ids(new String[]{"api-to-delete", "api-to-update", "unknown"}).build())).thenReturn(Arrays.asList(apiToUpdate, apiToDelete));
        Mockito.when((Object)apiRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().name("api-to-findById name").build())).thenReturn(Collections.singletonList(apiToFindById));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().category("my-category").build())).thenReturn(Collections.singletonList(apiToFindById));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().name("api-to-findById name").version("1").build())).thenReturn(Collections.singletonList(apiToFindById));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().name("api-to-findById name").version("1").build(), new ApiFieldExclusionFilter.Builder().excludeDefinition().build())).thenReturn(Collections.singletonList(apiToFindById));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().groups(new String[]{"api-group", "unknown"}).build())).thenReturn(Collections.singletonList(groupedApi));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().version("1").build())).thenReturn(Arrays.asList(apiToFindById, groupedApi, apiToDelete, apiToUpdate));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().label("label 1").build())).thenReturn(Collections.singletonList(apiToFindById));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().state(LifecycleState.STOPPED).build())).thenReturn(Arrays.asList(apiToFindById, groupedApi, apiToDelete, apiToUpdate));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().visibility(Visibility.PUBLIC).build())).thenReturn(Arrays.asList(apiToFindById, groupedApi));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().environmentId("DEFAULT").build())).thenReturn(Arrays.asList(apiToFindById, groupedApi));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().version("1").build(), new PageableBuilder().pageNumber(0).pageSize(2).build())).thenReturn((Object)new Page(Arrays.asList(apiToDelete, apiToFindById), 0, 2, 4L));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().version("1").build(), new PageableBuilder().pageNumber(1).pageSize(2).build())).thenReturn((Object)new Page(Arrays.asList(apiToUpdate, groupedApi), 1, 2, 4L));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().version("1").build(), new PageableBuilder().build())).thenReturn((Object)new Page(Arrays.asList(apiToDelete, apiToFindById, apiToUpdate, groupedApi), 0, 4, 4L));
        Mockito.when((Object)apiRepository.search(new ApiCriteria.Builder().lifecycleStates(Collections.singletonList(ApiLifecycleState.PUBLISHED)).build())).thenReturn(Arrays.asList(apiToUpdate, groupedApi, apiToUpdate));
    }
}

