/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class ApplicationRepositoryMock
extends AbstractRepositoryMock<ApplicationRepository> {
    public ApplicationRepositoryMock() {
        super(ApplicationRepository.class);
    }

    @Override
    void prepare(ApplicationRepository applicationRepository) throws Exception {
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)application.getId()).thenReturn((Object)"application-sample");
        Mockito.when((Object)application.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)application.getType()).thenReturn((Object)ApplicationType.SIMPLE);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("client_id", "my-client-id");
        metadata.put("type", "Web");
        Mockito.when((Object)application.getMetadata()).thenReturn(metadata);
        Mockito.when((Object)applicationRepository.findById((Object)"application-sample")).thenReturn(Optional.of(application));
        Set allApplications = Sets.newSet((Object[])new Application[]{application, (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class)});
        Set allApplicationsForDefaultEnvironment = Sets.newSet((Object[])new Application[]{application, (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class), (Application)Mockito.mock(Application.class)});
        Mockito.when((Object)applicationRepository.findAll(new ApplicationStatus[0])).thenReturn((Object)allApplications);
        Mockito.when((Object)applicationRepository.findAllByEnvironment("DEFAULT", new ApplicationStatus[0])).thenReturn((Object)allApplicationsForDefaultEnvironment);
        ((ApplicationRepository)Mockito.doAnswer(invocation -> allApplications.remove(application)).when((Object)applicationRepository)).delete((Object)"deleted-app");
        Mockito.when((Object)applicationRepository.findById((Object)"deleted-app")).thenReturn(Optional.empty());
        Application newApplication = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)newApplication.getName()).thenReturn((Object)"created-app");
        Mockito.when((Object)newApplication.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)newApplication.getDescription()).thenReturn((Object)"Application description");
        Mockito.when((Object)newApplication.getStatus()).thenReturn((Object)ApplicationStatus.ACTIVE);
        Mockito.when((Object)newApplication.getType()).thenReturn((Object)ApplicationType.SIMPLE);
        Mockito.when((Object)newApplication.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)newApplication.getUpdatedAt()).thenReturn((Object)DateUtils.parse("12/02/2016"));
        Mockito.when((Object)newApplication.isDisableMembershipNotifications()).thenReturn((Object)true);
        HashMap<String, String> createMetadata = new HashMap<String, String>();
        createMetadata.put("type", "app-type");
        Mockito.when((Object)newApplication.getMetadata()).thenReturn(createMetadata);
        Mockito.when((Object)applicationRepository.findById((Object)"created-app")).thenReturn(Optional.of(newApplication));
        Application updatedApplication = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)updatedApplication.getId()).thenReturn((Object)"updated-app");
        Mockito.when((Object)updatedApplication.getEnvironmentId()).thenReturn((Object)"new_DEFAULT");
        Mockito.when((Object)updatedApplication.getName()).thenReturn((Object)"updated-app");
        Mockito.when((Object)updatedApplication.getDescription()).thenReturn((Object)"Updated description");
        Mockito.when((Object)updatedApplication.getPicture()).thenReturn((Object)"New picture");
        Mockito.when((Object)updatedApplication.getBackground()).thenReturn((Object)"New background");
        Mockito.when((Object)updatedApplication.getStatus()).thenReturn((Object)ApplicationStatus.ARCHIVED);
        Mockito.when((Object)updatedApplication.getType()).thenReturn((Object)ApplicationType.SIMPLE);
        Mockito.when((Object)updatedApplication.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)updatedApplication.getUpdatedAt()).thenReturn((Object)DateUtils.parse("22/02/2016"));
        Mockito.when((Object)updatedApplication.isDisableMembershipNotifications()).thenReturn((Object)true);
        HashMap<String, String> updateMetadata = new HashMap<String, String>();
        updateMetadata.put("type", "update-type");
        Mockito.when((Object)updatedApplication.getMetadata()).thenReturn(updateMetadata);
        Mockito.when((Object)applicationRepository.findById((Object)"updated-app")).thenReturn(Optional.of(updatedApplication));
        Application groupedApplication1 = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)groupedApplication1.getId()).thenReturn((Object)"grouped-app1");
        Mockito.when((Object)groupedApplication1.getGroups()).thenReturn(Collections.singleton("application-group"));
        Mockito.when((Object)applicationRepository.findById((Object)"grouped-app1")).thenReturn(Optional.of(groupedApplication1));
        Application groupedApplication2 = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)groupedApplication2.getId()).thenReturn((Object)"grouped-app2");
        Mockito.when((Object)groupedApplication2.getGroups()).thenReturn(Collections.singleton("application-group"));
        Mockito.when((Object)applicationRepository.findById((Object)"grouped-app2")).thenReturn(Optional.of(groupedApplication2));
        Set allArchivedApplications = Sets.newSet((Object[])new Application[]{groupedApplication2});
        Mockito.when((Object)applicationRepository.findAll(new ApplicationStatus[]{ApplicationStatus.ARCHIVED})).thenReturn((Object)allArchivedApplications);
        Application searchedApp1 = (Application)Mockito.mock(Application.class);
        Application searchedApp2 = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)searchedApp1.getId()).thenReturn((Object)"searched-app1");
        Mockito.when((Object)searchedApp1.getName()).thenReturn((Object)"searched-app1");
        Mockito.when((Object)searchedApp2.getId()).thenReturn((Object)"searched-app2");
        Mockito.when((Object)searchedApp2.getName()).thenReturn((Object)"searched-app2");
        Mockito.when((Object)applicationRepository.findByName("searched-app1")).thenReturn(Collections.singleton(searchedApp1));
        Mockito.when((Object)applicationRepository.findByName("arched")).thenReturn((Object)Sets.newSet((Object[])new Application[]{searchedApp1, searchedApp2}));
        Mockito.when((Object)applicationRepository.findByName("aRcHEd")).thenReturn((Object)Sets.newSet((Object[])new Application[]{searchedApp1, searchedApp2}));
        Mockito.when((Object)applicationRepository.findByIds(Arrays.asList("searched-app1", "searched-app2"))).thenReturn((Object)Sets.newSet((Object[])new Application[]{searchedApp1, searchedApp2}));
        Mockito.when((Object)applicationRepository.findByGroups(Collections.singletonList("application-group"), new ApplicationStatus[0])).thenReturn((Object)Sets.newSet((Object[])new Application[]{groupedApplication1, groupedApplication2}));
        Mockito.when((Object)applicationRepository.findByGroups(Collections.singletonList("application-group"), new ApplicationStatus[]{ApplicationStatus.ARCHIVED})).thenReturn((Object)Sets.newSet((Object[])new Application[]{groupedApplication2}));
        Mockito.when((Object)applicationRepository.findByGroups(Collections.emptyList(), new ApplicationStatus[0])).thenReturn(Collections.emptySet());
        Mockito.when((Object)applicationRepository.findByIds(Arrays.asList("application-sample", "updated-app", "unknown"))).thenReturn(new HashSet<Application>(Arrays.asList(application, updatedApplication)));
        Mockito.when((Object)applicationRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

