/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.search.AuditCriteria;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Plan;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AuditRepositoryMock
extends AbstractRepositoryMock<AuditRepository> {
    public AuditRepositoryMock() {
        super(AuditRepository.class);
    }

    @Override
    void prepare(AuditRepository auditRepository) throws Exception {
        Audit newAudit = (Audit)Mockito.mock(Audit.class);
        Mockito.when((Object)newAudit.getId()).thenReturn((Object)"new");
        Mockito.when((Object)newAudit.getReferenceType()).thenReturn((Object)Audit.AuditReferenceType.API);
        Mockito.when((Object)newAudit.getReferenceId()).thenReturn((Object)"1");
        Mockito.when((Object)newAudit.getEvent()).thenReturn((Object)Plan.AuditEvent.PLAN_CREATED.name());
        Mockito.when((Object)newAudit.getProperties()).thenReturn(Collections.singletonMap(Audit.AuditProperties.PLAN.name(), "123"));
        Mockito.when((Object)newAudit.getUser()).thenReturn((Object)"JohnDoe");
        Mockito.when((Object)newAudit.getPatch()).thenReturn((Object)"diff");
        Mockito.when((Object)newAudit.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)auditRepository.findById((Object)"new")).thenReturn(Optional.of(newAudit));
        Audit searchable1 = (Audit)Mockito.mock(Audit.class);
        Mockito.when((Object)searchable1.getId()).thenReturn((Object)"searchable1");
        Audit searchable2 = (Audit)Mockito.mock(Audit.class);
        Mockito.when((Object)searchable2.getId()).thenReturn((Object)"searchable2");
        Mockito.when((Object)auditRepository.search((AuditCriteria)Matchers.argThat(o -> o != null && o.getReferences() != null && !o.getReferences().isEmpty()), (Pageable)Matchers.any())).thenReturn((Object)new Page(Collections.singletonList(searchable2), 0, 1, 2L));
        Mockito.when((Object)auditRepository.search((AuditCriteria)Matchers.argThat(o -> o != null && o.getEvents() != null && ((String)o.getEvents().get(0)).equals(Plan.AuditEvent.PLAN_UPDATED.name())), (Pageable)Matchers.any())).thenReturn((Object)new Page(Collections.singletonList(searchable2), 0, 1, 1L));
        Mockito.when((Object)auditRepository.search((AuditCriteria)Matchers.argThat(o -> !(o == null || o.getEvents() != null && !o.getEvents().isEmpty() || o.getReferences() != null && !o.getReferences().isEmpty())), (Pageable)Matchers.any())).thenReturn((Object)new Page(Arrays.asList(searchable2, newAudit, searchable1), 0, 3, 3L));
        Mockito.when((Object)auditRepository.search((AuditCriteria)Matchers.argThat(o -> o != null && o.getFrom() > 0L && o.getTo() > 0L), (Pageable)Matchers.any())).thenReturn((Object)new Page(Collections.singletonList(searchable2), 0, 1, 1L));
        Mockito.when((Object)auditRepository.search((AuditCriteria)Matchers.argThat(o -> o != null && o.getFrom() > 0L && o.getTo() == 0L), (Pageable)Matchers.any())).thenReturn((Object)new Page(Arrays.asList((Audit)Mockito.mock(Audit.class), (Audit)Mockito.mock(Audit.class), (Audit)Mockito.mock(Audit.class)), 0, 2, 3L), (Object[])new Page[]{new Page(Arrays.asList((Audit)Mockito.mock(Audit.class), (Audit)Mockito.mock(Audit.class), (Audit)Mockito.mock(Audit.class)), 1, 1, 3L)});
        Mockito.when((Object)auditRepository.search((AuditCriteria)Matchers.argThat(o -> o != null && o.getFrom() == 0L && o.getTo() > 0L), (Pageable)Matchers.any())).thenReturn((Object)new Page(Collections.singletonList(Mockito.mock(Audit.class)), 0, 1, 1L));
    }
}

