/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.model.Category;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class CategoryRepositoryMock
extends AbstractRepositoryMock<CategoryRepository> {
    public CategoryRepositoryMock() {
        super(CategoryRepository.class);
    }

    @Override
    void prepare(CategoryRepository categoryRepository) throws Exception {
        Category newCategory = (Category)Mockito.mock(Category.class);
        Mockito.when((Object)newCategory.getId()).thenReturn((Object)"fd19297e-01a3-4828-9929-7e01a3782809");
        Mockito.when((Object)newCategory.getKey()).thenReturn((Object)"new-category");
        Mockito.when((Object)newCategory.getName()).thenReturn((Object)"Category name");
        Mockito.when((Object)newCategory.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)newCategory.getDescription()).thenReturn((Object)"Description for the new category");
        Mockito.when((Object)newCategory.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)newCategory.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)newCategory.isHidden()).thenReturn((Object)true);
        Mockito.when((Object)newCategory.getOrder()).thenReturn((Object)1);
        Mockito.when((Object)newCategory.getPicture()).thenReturn((Object)"New picture");
        Mockito.when((Object)newCategory.getBackground()).thenReturn((Object)"New background");
        Mockito.when((Object)newCategory.getPage()).thenReturn((Object)"documentationPageId");
        Category categoryProducts = new Category();
        categoryProducts.setId("category");
        categoryProducts.setEnvironmentId("DEFAULT");
        categoryProducts.setName("Products");
        categoryProducts.setPage("documentationPageId");
        categoryProducts.setCreatedAt(new Date(1000000000000L));
        categoryProducts.setUpdatedAt(new Date(1111111111111L));
        categoryProducts.setHidden(false);
        categoryProducts.setOrder(1);
        Category categoryProductsUpdated = (Category)Mockito.mock(Category.class);
        Mockito.when((Object)categoryProductsUpdated.getName()).thenReturn((Object)"New product");
        Mockito.when((Object)categoryProductsUpdated.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)categoryProductsUpdated.getDescription()).thenReturn((Object)"New description");
        Mockito.when((Object)categoryProductsUpdated.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)categoryProductsUpdated.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)categoryProductsUpdated.isHidden()).thenReturn((Object)true);
        Mockito.when((Object)categoryProductsUpdated.getOrder()).thenReturn((Object)10);
        Mockito.when((Object)categoryProductsUpdated.getHighlightApi()).thenReturn((Object)"new Highlighted API");
        Mockito.when((Object)categoryProductsUpdated.getPicture()).thenReturn((Object)"New picture");
        Mockito.when((Object)categoryProductsUpdated.getBackground()).thenReturn((Object)"New background");
        Mockito.when((Object)categoryProductsUpdated.getPage()).thenReturn((Object)"documentationPageId");
        Category myCategory = new Category();
        myCategory.setId("123");
        myCategory.setKey("my-category");
        myCategory.setName("My category");
        myCategory.setCreatedAt(new Date(1000000000000L));
        myCategory.setUpdatedAt(new Date(1111111111111L));
        myCategory.setHidden(false);
        myCategory.setOrder(3);
        Set categories = Sets.newSet((Object[])new Category[]{newCategory, categoryProducts, (Category)Mockito.mock(Category.class), myCategory});
        Set categoriesAfterDelete = Sets.newSet((Object[])new Category[]{newCategory, categoryProducts, myCategory});
        Set categoriesAfterAdd = Sets.newSet((Object[])new Category[]{newCategory, categoryProducts, (Category)Mockito.mock(Category.class), (Category)Mockito.mock(Category.class), myCategory});
        Mockito.when((Object)categoryRepository.findAll()).thenReturn((Object)categories, (Object[])new Set[]{categoriesAfterAdd, categories, categoriesAfterDelete, categories});
        Mockito.when((Object)categoryRepository.findAllByEnvironment("DEFAULT")).thenReturn((Object)categories);
        Mockito.when((Object)categoryRepository.create((Category)Mockito.any(Category.class))).thenReturn((Object)newCategory);
        Mockito.when((Object)categoryRepository.findById("fd19297e-01a3-4828-9929-7e01a3782809")).thenReturn(Optional.of(newCategory));
        Mockito.when((Object)categoryRepository.findById("unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)categoryRepository.findById("products")).thenReturn(Optional.of(categoryProducts), (Object[])new Optional[]{Optional.of(categoryProductsUpdated)});
        Mockito.when((Object)categoryRepository.findByKey("my-category", "DEFAULT")).thenReturn(Optional.of(myCategory));
        Mockito.when((Object)categoryRepository.findByPage("documentationPageId")).thenReturn((Object)Sets.newSet((Object[])new Category[]{newCategory, categoryProducts, categoryProductsUpdated}));
        Mockito.when((Object)categoryRepository.update((Category)Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

