/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.ClientRegistrationProviderRepository;
import io.gravitee.repository.management.model.ClientRegistrationProvider;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class ClientRegistrationProviderRepositoryMock
extends AbstractRepositoryMock<ClientRegistrationProviderRepository> {
    public ClientRegistrationProviderRepositoryMock() {
        super(ClientRegistrationProviderRepository.class);
    }

    @Override
    void prepare(ClientRegistrationProviderRepository clientRegistrationProviderRepository) throws Exception {
        ClientRegistrationProvider newClientRegistrationProvider = (ClientRegistrationProvider)Mockito.mock(ClientRegistrationProvider.class);
        Mockito.when((Object)newClientRegistrationProvider.getName()).thenReturn((Object)"new DCR");
        Mockito.when((Object)newClientRegistrationProvider.getDescription()).thenReturn((Object)"Description for my new DCR");
        Mockito.when((Object)newClientRegistrationProvider.getDiscoveryEndpoint()).thenReturn((Object)"http://localhost:8092/oidc/.well-known/openid-configuration");
        Mockito.when((Object)newClientRegistrationProvider.getInitialAccessTokenType()).thenReturn((Object)ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS);
        Mockito.when((Object)newClientRegistrationProvider.getClientId()).thenReturn((Object)"my-client-id");
        Mockito.when((Object)newClientRegistrationProvider.getClientSecret()).thenReturn((Object)"my-client-secret");
        Mockito.when((Object)newClientRegistrationProvider.getScopes()).thenReturn(Arrays.asList("scope1", "scope2", "scope3"));
        Mockito.when((Object)newClientRegistrationProvider.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)newClientRegistrationProvider.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        ClientRegistrationProvider clientRegistrationProvider1 = new ClientRegistrationProvider();
        clientRegistrationProvider1.setId("github");
        clientRegistrationProvider1.setName("OIDC-1");
        clientRegistrationProvider1.setDescription("GitHub Identity Provider");
        clientRegistrationProvider1.setCreatedAt(new Date(1000000000000L));
        clientRegistrationProvider1.setUpdatedAt(new Date(1486771200000L));
        ClientRegistrationProvider clientRegistrationProviderUpdated = (ClientRegistrationProvider)Mockito.mock(ClientRegistrationProvider.class);
        Mockito.when((Object)clientRegistrationProviderUpdated.getName()).thenReturn((Object)"OIDC-1");
        Mockito.when((Object)clientRegistrationProviderUpdated.getDescription()).thenReturn((Object)"OIDC 1 Client registration provider");
        Mockito.when((Object)clientRegistrationProviderUpdated.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)clientRegistrationProviderUpdated.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        ClientRegistrationProvider clientRegistrationProvider3 = this.createMock();
        Set clientRegistrationProviders = Sets.newSet((Object[])new ClientRegistrationProvider[]{newClientRegistrationProvider, clientRegistrationProvider1, (ClientRegistrationProvider)Mockito.mock(ClientRegistrationProvider.class)});
        Set clientRegistrationProvidersAfterDelete = Sets.newSet((Object[])new ClientRegistrationProvider[]{newClientRegistrationProvider, clientRegistrationProvider1});
        Set clientRegistrationProvidersAfterAdd = Sets.newSet((Object[])new ClientRegistrationProvider[]{newClientRegistrationProvider, clientRegistrationProvider1, (ClientRegistrationProvider)Mockito.mock(ClientRegistrationProvider.class), (ClientRegistrationProvider)Mockito.mock(ClientRegistrationProvider.class)});
        Mockito.when((Object)clientRegistrationProviderRepository.findAll()).thenReturn((Object)clientRegistrationProviders, (Object[])new Set[]{clientRegistrationProvidersAfterAdd, clientRegistrationProviders, clientRegistrationProvidersAfterDelete, clientRegistrationProviders});
        Mockito.when((Object)clientRegistrationProviderRepository.create(Matchers.any(ClientRegistrationProvider.class))).thenReturn((Object)newClientRegistrationProvider);
        Mockito.when((Object)clientRegistrationProviderRepository.findById((Object)"new-dcr")).thenReturn(Optional.of(newClientRegistrationProvider));
        Mockito.when((Object)clientRegistrationProviderRepository.findById((Object)"unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)clientRegistrationProviderRepository.findById((Object)"oidc1")).thenReturn(Optional.of(clientRegistrationProvider1), (Object[])new Optional[]{Optional.of(clientRegistrationProviderUpdated)});
        Mockito.when((Object)clientRegistrationProviderRepository.findById((Object)"oidc3")).thenReturn(Optional.of(clientRegistrationProvider3));
        Mockito.when((Object)clientRegistrationProviderRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }

    private ClientRegistrationProvider createMock() {
        ClientRegistrationProvider clientRegistrationProvider3 = new ClientRegistrationProvider();
        clientRegistrationProvider3.setId("oidc3");
        clientRegistrationProvider3.setName("OIDC-3");
        clientRegistrationProvider3.setDescription("OIDC Client registration provider");
        clientRegistrationProvider3.setDiscoveryEndpoint("http://localhost:8092/oidc/.well-known/openid-configuration");
        clientRegistrationProvider3.setClientId("my-client-id");
        clientRegistrationProvider3.setClientSecret("my-client-secret");
        clientRegistrationProvider3.setScopes(Arrays.asList("scope1", "scope2", "scope3"));
        clientRegistrationProvider3.setRenewClientSecretSupport(true);
        clientRegistrationProvider3.setRenewClientSecretEndpoint("http://localhost/endpoint");
        clientRegistrationProvider3.setRenewClientSecretMethod("POST");
        clientRegistrationProvider3.setCreatedAt(new Date(1000000000000L));
        clientRegistrationProvider3.setUpdatedAt(new Date(1486771200000L));
        clientRegistrationProvider3.setInitialAccessTokenType(ClientRegistrationProvider.InitialAccessTokenType.CLIENT_CREDENTIALS);
        return clientRegistrationProvider3;
    }
}

