/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.search.CommandCriteria;
import io.gravitee.repository.management.model.Command;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CommandRepositoryMock
extends AbstractRepositoryMock<CommandRepository> {
    public CommandRepositoryMock() {
        super(CommandRepository.class);
    }

    @Override
    void prepare(CommandRepository commandRepository) throws Exception {
        Command newCommand = new Command();
        newCommand.setId("msg-to-create");
        newCommand.setEnvironmentId("DEFAULT");
        newCommand.setTo("someone");
        newCommand.setTags(Arrays.asList("INSERT", "DATA_TO_INDEX"));
        newCommand.setContent("Hello, is it me you're looking for?");
        newCommand.setAcknowledgments(Arrays.asList("1", "a"));
        newCommand.setCreatedAt(new Date(1546305346000L));
        newCommand.setUpdatedAt(new Date(1548983746000L));
        newCommand.setExpiredAt(new Date(1551402946000L));
        Mockito.when((Object)commandRepository.findById((Object)"msg-to-create")).thenReturn(Optional.of(newCommand));
        Command updatedCommand = new Command();
        updatedCommand.setId("msg-to-update");
        updatedCommand.setEnvironmentId("new_DEFAULT");
        updatedCommand.setTo("message updated");
        updatedCommand.setFrom("from updated");
        updatedCommand.setTags(Collections.singletonList("DELETE"));
        updatedCommand.setContent("updated content");
        updatedCommand.setAcknowledgments(Arrays.asList("up", "date"));
        updatedCommand.setCreatedAt(new Date(1546405346000L));
        updatedCommand.setUpdatedAt(new Date(1546505346000L));
        updatedCommand.setExpiredAt(new Date(1546605346000L));
        Mockito.when((Object)commandRepository.update(ArgumentMatchers.argThat(o -> o != null && o.getId().equals("msg-to-update")))).thenReturn((Object)updatedCommand);
        Mockito.when((Object)commandRepository.update(ArgumentMatchers.argThat(o -> o != null && o.getId() == null))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)commandRepository.update(ArgumentMatchers.argThat(Objects::isNull))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)commandRepository.findById((Object)"msg-to-delete")).thenReturn(Optional.of(Mockito.mock(Command.class)), (Object[])new Optional[]{Optional.empty()});
        Command search1 = new Command();
        search1.setId("search1");
        Command search2 = new Command();
        search2.setId("search2");
        Command search3 = new Command();
        search3.setId("search3");
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && o.getNotFrom() != null))).thenReturn(Arrays.asList(newCommand, updatedCommand, (Command)Mockito.mock(Command.class), search2, search3));
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && o.getTo() != null))).thenReturn(Collections.singletonList(search3));
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && o.getTags() != null && o.getTags().length == 1))).thenReturn(Arrays.asList(newCommand, updatedCommand, search1, search2));
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && o.getTags() != null && o.getTags().length == 2))).thenReturn(Collections.singletonList(search3));
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && o.getNotAckBy() != null))).thenReturn(Arrays.asList(newCommand, updatedCommand, (Command)Mockito.mock(Command.class), search2));
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && o.isNotExpired()))).thenReturn(Collections.singletonList(search2));
        Mockito.when((Object)commandRepository.search((CommandCriteria)ArgumentMatchers.argThat(o -> o != null && "DEFAULT".equals(o.getEnvironmentId())))).thenReturn(Collections.singletonList(newCommand));
    }
}

