/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.CustomUserFieldsRepository;
import io.gravitee.repository.management.model.CustomUserField;
import io.gravitee.repository.management.model.CustomUserFieldReferenceType;
import io.gravitee.repository.management.model.MetadataFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CustomUserFieldsRepositoryMock
extends AbstractRepositoryMock<CustomUserFieldsRepository> {
    public CustomUserFieldsRepositoryMock() {
        super(CustomUserFieldsRepository.class);
    }

    @Override
    void prepare(CustomUserFieldsRepository customUserFieldsRepository) throws Exception {
        CustomUserField stringCustomUserField = (CustomUserField)Mockito.mock(CustomUserField.class);
        Mockito.when((Object)stringCustomUserField.getKey()).thenReturn((Object)"string");
        Mockito.when((Object)stringCustomUserField.getLabel()).thenReturn((Object)"String");
        Mockito.when((Object)stringCustomUserField.getReferenceId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)stringCustomUserField.getReferenceType()).thenReturn((Object)CustomUserFieldReferenceType.ORGANIZATION);
        Mockito.when((Object)stringCustomUserField.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)stringCustomUserField.getValues()).thenReturn(Arrays.asList("test_values"));
        Mockito.when((Object)stringCustomUserField.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)stringCustomUserField.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)customUserFieldsRepository.findById((String)ArgumentMatchers.argThat(key -> "string".equals(key)), (String)ArgumentMatchers.argThat(refid -> "DEFAULT".equals(refid)), (CustomUserFieldReferenceType)ArgumentMatchers.argThat(org -> CustomUserFieldReferenceType.ORGANIZATION.equals(org)))).thenReturn(Optional.of(stringCustomUserField));
        CustomUserField string = new CustomUserField();
        string.setKey("string");
        CustomUserField bool = new CustomUserField();
        bool.setKey("boolean");
        CustomUserField update = new CustomUserField();
        update.setKey("updateKey");
        CustomUserField delete = new CustomUserField();
        delete.setKey("deleteKey");
        Mockito.when((Object)customUserFieldsRepository.findByReferenceIdAndReferenceType("DEFAULT", CustomUserFieldReferenceType.ORGANIZATION)).thenReturn(Arrays.asList(string, bool, update, delete));
        CustomUserField newCustomUserField = new CustomUserField();
        newCustomUserField.setKey("newkey");
        newCustomUserField.setLabel("newkeyLabel");
        newCustomUserField.setReferenceId("DEFAULT");
        newCustomUserField.setReferenceType(CustomUserFieldReferenceType.ORGANIZATION);
        newCustomUserField.setFormat(MetadataFormat.MAIL);
        newCustomUserField.setRequired(false);
        newCustomUserField.setValues(Arrays.asList("test@domain.net"));
        Mockito.when((Object)customUserFieldsRepository.findById((String)ArgumentMatchers.argThat(key -> "newkey".equals(key)), (String)ArgumentMatchers.argThat(refid -> "DEFAULT".equals(refid)), (CustomUserFieldReferenceType)ArgumentMatchers.argThat(org -> CustomUserFieldReferenceType.ORGANIZATION.equals(org)))).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(newCustomUserField)});
        Mockito.when((Object)customUserFieldsRepository.create((CustomUserField)ArgumentMatchers.any())).thenReturn((Object)newCustomUserField);
        CustomUserField toUpdateField = new CustomUserField();
        toUpdateField.setKey("updateKey");
        toUpdateField.setLabel("label");
        toUpdateField.setReferenceId("DEFAULT");
        toUpdateField.setReferenceType(CustomUserFieldReferenceType.ORGANIZATION);
        toUpdateField.setFormat(MetadataFormat.MAIL);
        toUpdateField.setRequired(false);
        CustomUserField updatedField = new CustomUserField();
        updatedField.setKey("updateKey");
        updatedField.setLabel("LabelUPDATED");
        updatedField.setReferenceId("DEFAULT");
        updatedField.setReferenceType(CustomUserFieldReferenceType.ORGANIZATION);
        updatedField.setFormat(MetadataFormat.MAIL);
        updatedField.setRequired(true);
        updatedField.setValues(Arrays.asList("test@domain.net2"));
        Mockito.when((Object)customUserFieldsRepository.findById((String)ArgumentMatchers.argThat(key -> "updateKey".equals(key)), (String)ArgumentMatchers.argThat(refid -> "DEFAULT".equals(refid)), (CustomUserFieldReferenceType)ArgumentMatchers.argThat(refType -> CustomUserFieldReferenceType.ORGANIZATION.equals(refType)))).thenReturn(Optional.of(toUpdateField), (Object[])new Optional[]{Optional.of(updatedField)});
        Mockito.when((Object)customUserFieldsRepository.update((CustomUserField)ArgumentMatchers.any())).thenReturn((Object)updatedField);
        Mockito.when((Object)customUserFieldsRepository.findById((String)ArgumentMatchers.argThat(key -> "deleteKey".equals(key)), (String)ArgumentMatchers.argThat(refid -> "DEFAULT".equals(refid)), (CustomUserFieldReferenceType)ArgumentMatchers.argThat(refType -> CustomUserFieldReferenceType.ORGANIZATION.equals(refType)))).thenReturn(Optional.of(new CustomUserField()), (Object[])new Optional[]{Optional.empty()});
    }
}

