/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.DashboardRepository;
import io.gravitee.repository.management.model.Dashboard;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class DashboardRepositoryMock
extends AbstractRepositoryMock<DashboardRepository> {
    public DashboardRepositoryMock() {
        super(DashboardRepository.class);
    }

    @Override
    void prepare(DashboardRepository dashboardRepository) throws Exception {
        Dashboard dashboard1 = this.mockDashboard("2535437f-ee99-4ab8-b543-7fee995ab847", "PLATFORM", "DEFAULT", "Global dashboard", null, 0, true, "{\"def\": \"value\"}", false);
        Dashboard dashboard2 = this.mockDashboard("4eeb1c56-6f4a-4925-ab1c-566f4aa925b8", "PLATFORM", "DEFAULT", "Geo dashboard", null, 1, true, "{\"def\": \"value\"}", false);
        Dashboard dashboard3 = this.mockDashboard("6e0d09f0-ba5d-4571-8d09-f0ba5d7571c3", "PLATFORM", "DEFAULT", "Device dashboard", null, 2, false, "{\"def\": \"value\"}", false);
        Dashboard dashboard4 = this.mockDashboard("2535437f-ee99-4ab8-b543-7fee995ab847", "API", "DEFAULT", "Global dashboard", null, 0, true, "{\"def\": \"value\"}", false);
        Dashboard createdDashboard = this.mockDashboard("new-dashboard", "API", "DEFAULT", "Dashboard name", "api:apiId", 1, true, "{\"def\": \"value\"}", false);
        Dashboard updatedDashboard = this.mockDashboard("6e0d09f0-ba5d-4571-8d09-f0ba5d7571c3", "PLATFORM", "1", "New dashboard", "api:apiId", 3, true, "{\"def\": \"new value\"}", true);
        Mockito.when((Object)dashboardRepository.create(Mockito.any(Dashboard.class))).thenReturn((Object)createdDashboard);
        Mockito.when((Object)dashboardRepository.findAll()).thenReturn((Object)Sets.newSet((Object[])new Dashboard[]{dashboard1, dashboard2, dashboard3, dashboard4}));
        Mockito.when((Object)dashboardRepository.findById((Object)"new-dashboard")).thenReturn(Optional.of(createdDashboard));
        Mockito.when((Object)dashboardRepository.findById((Object)"6e0d09f0-ba5d-4571-8d09-f0ba5d7571c3")).thenReturn(Optional.of(dashboard3), (Object[])new Optional[]{Optional.of(updatedDashboard)});
        Mockito.when((Object)dashboardRepository.findByReferenceType("PLATFORM")).thenReturn(Arrays.asList(dashboard1, dashboard2, dashboard3));
        Mockito.when((Object)dashboardRepository.findByReferenceType("API")).thenReturn(Collections.singletonList(dashboard4), (Object[])new List[]{Arrays.asList(dashboard4, createdDashboard), Collections.singletonList(dashboard4), Collections.emptyList()});
        Mockito.when((Object)dashboardRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }

    private Dashboard mockDashboard(String id, String referenceType, String referenceId, String name, String queryFilter, int order, boolean enabled, String definition, boolean switchDates) {
        Dashboard dashboard = (Dashboard)Mockito.mock(Dashboard.class);
        Mockito.when((Object)dashboard.getId()).thenReturn((Object)id);
        Mockito.when((Object)dashboard.getReferenceType()).thenReturn((Object)referenceType);
        Mockito.when((Object)dashboard.getReferenceId()).thenReturn((Object)referenceId);
        Mockito.when((Object)dashboard.getName()).thenReturn((Object)name);
        Mockito.when((Object)dashboard.getQueryFilter()).thenReturn((Object)queryFilter);
        Mockito.when((Object)dashboard.getOrder()).thenReturn((Object)order);
        Mockito.when((Object)dashboard.isEnabled()).thenReturn((Object)enabled);
        Mockito.when((Object)dashboard.getDefinition()).thenReturn((Object)definition);
        if (switchDates) {
            Mockito.when((Object)dashboard.getCreatedAt()).thenReturn((Object)new Date(1111111111111L));
            Mockito.when((Object)dashboard.getUpdatedAt()).thenReturn((Object)new Date(1000000000000L));
        } else {
            Mockito.when((Object)dashboard.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
            Mockito.when((Object)dashboard.getUpdatedAt()).thenReturn((Object)new Date(1111111111111L));
        }
        return dashboard;
    }
}

