/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.DictionaryType;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class DictionaryRepositoryMock
extends AbstractRepositoryMock<DictionaryRepository> {
    public DictionaryRepositoryMock() {
        super(DictionaryRepository.class);
    }

    @Override
    void prepare(DictionaryRepository dictionaryRepository) throws Exception {
        Dictionary newDictionary = (Dictionary)Mockito.mock(Dictionary.class);
        Mockito.when((Object)newDictionary.getName()).thenReturn((Object)"My dic 1");
        Mockito.when((Object)newDictionary.getEnvironmentId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)newDictionary.getDescription()).thenReturn((Object)"Description for my dic 1");
        Mockito.when((Object)newDictionary.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)newDictionary.getUpdatedAt()).thenReturn((Object)new Date(1439032010883L));
        Mockito.when((Object)newDictionary.getType()).thenReturn((Object)DictionaryType.MANUAL);
        Dictionary dic1 = new Dictionary();
        dic1.setId("dic-1");
        dic1.setEnvironmentId("DEFAULT");
        dic1.setName("My dic 1");
        dic1.setDescription("Description for my dic 1");
        dic1.setCreatedAt(new Date(1000000000000L));
        dic1.setUpdatedAt(new Date(1439032010883L));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("localhost", "localhost");
        props.put("localhost:8082", "localhost:8082");
        props.put("127.0.0.1:8082", "127.0.0.1:8082");
        dic1.setProperties(props);
        Dictionary dictionaryUpdated = (Dictionary)Mockito.mock(Dictionary.class);
        Mockito.when((Object)dictionaryUpdated.getName()).thenReturn((Object)"My dic 1");
        Mockito.when((Object)dictionaryUpdated.getEnvironmentId()).thenReturn((Object)"new_DEFAULT");
        Mockito.when((Object)dictionaryUpdated.getDescription()).thenReturn((Object)"Description for my dic 1");
        Mockito.when((Object)dictionaryUpdated.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)dictionaryUpdated.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)dictionaryUpdated.getType()).thenReturn((Object)DictionaryType.DYNAMIC);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("localhost", "localhost");
        properties.put("localhost:8082", "localhost:8082");
        properties.put("127.0.0.1:8082", "127.0.0.1:8082");
        Mockito.when((Object)dictionaryUpdated.getProperties()).thenReturn(properties);
        Set dictionaries = Sets.newSet((Object[])new Dictionary[]{newDictionary, dic1, (Dictionary)Mockito.mock(Dictionary.class)});
        Set dictionariesAfterDelete = Sets.newSet((Object[])new Dictionary[]{newDictionary, dic1});
        Set dictionariesAfterAdd = Sets.newSet((Object[])new Dictionary[]{newDictionary, dic1, (Dictionary)Mockito.mock(Dictionary.class), (Dictionary)Mockito.mock(Dictionary.class)});
        Mockito.when((Object)dictionaryRepository.findAll()).thenReturn((Object)dictionaries, (Object[])new Set[]{dictionariesAfterAdd, dictionaries, dictionariesAfterDelete, dictionaries});
        Mockito.when((Object)dictionaryRepository.findAllByEnvironment("DEFAULT")).thenReturn((Object)dictionaries);
        Mockito.when((Object)dictionaryRepository.create(Mockito.any(Dictionary.class))).thenReturn((Object)newDictionary);
        Mockito.when((Object)dictionaryRepository.findById((Object)"new-dictionary")).thenReturn(Optional.of(newDictionary));
        Mockito.when((Object)dictionaryRepository.findById((Object)"unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)dictionaryRepository.findById((Object)"dic-1")).thenReturn(Optional.of(dic1), (Object[])new Optional[]{Optional.of(dic1), Optional.of(dictionaryUpdated)});
        Mockito.when((Object)dictionaryRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

