/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.EntrypointRepository;
import io.gravitee.repository.management.model.Entrypoint;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class EntrypointRepositoryMock
extends AbstractRepositoryMock<EntrypointRepository> {
    public EntrypointRepositoryMock() {
        super(EntrypointRepository.class);
    }

    @Override
    void prepare(EntrypointRepository entrypointRepository) throws Exception {
        Entrypoint entrypoint = new Entrypoint();
        entrypoint.setId("new-entrypoint");
        entrypoint.setEnvironmentId("DEFAULT");
        entrypoint.setValue("Entry point value");
        entrypoint.setTags("internal;product");
        Entrypoint entrypoint2 = new Entrypoint();
        entrypoint2.setId("entrypoint");
        entrypoint.setEnvironmentId("DEFAULT");
        entrypoint2.setValue("https://public-api.company.com");
        Entrypoint entrypoint2Updated = new Entrypoint();
        entrypoint2Updated.setId("entrypoint");
        entrypoint2Updated.setEnvironmentId("new_DEFAULT");
        entrypoint2Updated.setValue("New value");
        entrypoint2Updated.setTags("New tags");
        Set entrypoints = Sets.newSet((Object[])new Entrypoint[]{entrypoint, entrypoint2, (Entrypoint)Mockito.mock(Entrypoint.class)});
        Set entrypointsAfterDelete = Sets.newSet((Object[])new Entrypoint[]{entrypoint, entrypoint2});
        Set entrypointsAfterAdd = Sets.newSet((Object[])new Entrypoint[]{entrypoint, entrypoint2, (Entrypoint)Mockito.mock(Entrypoint.class), (Entrypoint)Mockito.mock(Entrypoint.class)});
        Mockito.when((Object)entrypointRepository.findAll()).thenReturn((Object)entrypoints, (Object[])new Set[]{entrypointsAfterAdd, entrypoints, entrypointsAfterDelete, entrypoints});
        Mockito.when((Object)entrypointRepository.findAllByEnvironment("DEFAULT")).thenReturn((Object)entrypoints);
        Mockito.when((Object)entrypointRepository.create(Mockito.any(Entrypoint.class))).thenReturn((Object)entrypoint);
        Mockito.when((Object)entrypointRepository.findById((Object)"new-entrypoint")).thenReturn(Optional.of(entrypoint));
        Mockito.when((Object)entrypointRepository.findById((Object)"fa29c012-a0d2-4721-a9c0-12a0d26721db")).thenReturn(Optional.of(entrypoint2), (Object[])new Optional[]{Optional.of(entrypoint2Updated)});
        Mockito.when((Object)entrypointRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

