/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.model.Environment;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class EnvironmentRepositoryMock
extends AbstractRepositoryMock<EnvironmentRepository> {
    public EnvironmentRepositoryMock() {
        super(EnvironmentRepository.class);
    }

    @Override
    void prepare(EnvironmentRepository EnvironmentRepository2) throws Exception {
        Environment envCreate = new Environment();
        envCreate.setId("DEFAULT-create");
        envCreate.setName("Default env for create");
        envCreate.setDescription("Default env description for create");
        envCreate.setOrganizationId("DEFAULT-ORG");
        envCreate.setDomainRestrictions(Arrays.asList("domain", "restriction"));
        Environment env2Update = new Environment();
        env2Update.setId("DEFAULT-update");
        env2Update.setName("Default env for update");
        Environment envUpdated = new Environment();
        envUpdated.setId("DEFAULT-update");
        envUpdated.setName("New name");
        Environment envDelete = new Environment();
        envDelete.setId("DEFAULT-delete");
        envDelete.setName("Default env for delete");
        Environment envFindById = new Environment();
        envFindById.setId("DEFAULT-findById");
        envFindById.setName("Default env for findById");
        envCreate.setOrganizationId("DEFAULT-ORG");
        Mockito.when((Object)EnvironmentRepository2.create(ArgumentMatchers.any(Environment.class))).thenReturn((Object)envCreate);
        Mockito.when((Object)EnvironmentRepository2.update(ArgumentMatchers.any(Environment.class))).thenReturn((Object)envUpdated);
        Mockito.when((Object)EnvironmentRepository2.update(ArgumentMatchers.any(Environment.class))).thenReturn((Object)envUpdated);
        Mockito.when((Object)EnvironmentRepository2.findById((Object)"DEFAULT-create")).thenReturn(Optional.of(envCreate));
        Mockito.when((Object)EnvironmentRepository2.findById((Object)"DEFAULT-update")).thenReturn(Optional.of(env2Update), (Object[])new Optional[]{Optional.of(envUpdated)});
        Mockito.when((Object)EnvironmentRepository2.findById((Object)"DEFAULT-delete")).thenReturn(Optional.of(envDelete), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)EnvironmentRepository2.findById((Object)"DEFAULT-findById")).thenReturn(Optional.of(envFindById));
        Set allEnvironments = Sets.newSet((Object[])new Environment[]{envCreate, env2Update, envUpdated, envDelete, envFindById});
        Set orgEnvironments = Sets.newSet((Object[])new Environment[]{envFindById});
        Mockito.when((Object)EnvironmentRepository2.findAll()).thenReturn((Object)allEnvironments);
        Mockito.when((Object)EnvironmentRepository2.findByOrganization("DEFAULT-ORG")).thenReturn((Object)orgEnvironments);
    }
}

