/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.mockito.Mockito;

public class GenericNotificationConfigRepositoryMock
extends AbstractRepositoryMock<GenericNotificationConfigRepository> {
    public GenericNotificationConfigRepositoryMock() {
        super(GenericNotificationConfigRepository.class);
    }

    @Override
    void prepare(GenericNotificationConfigRepository genericNotificationConfigRepository) throws Exception {
        GenericNotificationConfig createdCfg = new GenericNotificationConfig();
        createdCfg.setId("new-id");
        createdCfg.setName("new config");
        createdCfg.setReferenceType(NotificationReferenceType.API);
        createdCfg.setReferenceId("config-created");
        createdCfg.setNotifier("notifierId");
        createdCfg.setConfig("my new configuration");
        createdCfg.setUseSystemProxy(true);
        createdCfg.setHooks(Arrays.asList("A", "B", "C"));
        createdCfg.setUpdatedAt(new Date(1439022010883L));
        createdCfg.setCreatedAt(new Date(1439022010883L));
        Mockito.when((Object)genericNotificationConfigRepository.create((GenericNotificationConfig)Mockito.any())).thenReturn((Object)createdCfg);
        GenericNotificationConfig updatedCfg = new GenericNotificationConfig();
        updatedCfg.setId("notif-to-update");
        updatedCfg.setName("notif-updated");
        updatedCfg.setReferenceType(NotificationReferenceType.API);
        updatedCfg.setReferenceId("config-to-update");
        updatedCfg.setNotifier("notifierId");
        updatedCfg.setConfig("updated configuration");
        updatedCfg.setUseSystemProxy(true);
        updatedCfg.setHooks(Arrays.asList("D", "B", "C"));
        updatedCfg.setUpdatedAt(new Date(1479022010883L));
        updatedCfg.setCreatedAt(new Date(1469022010883L));
        Mockito.when((Object)genericNotificationConfigRepository.update((GenericNotificationConfig)Mockito.any())).thenReturn((Object)updatedCfg);
        Mockito.when((Object)genericNotificationConfigRepository.findById("notif-to-delete")).thenReturn(Optional.of(Mockito.mock(GenericNotificationConfig.class)), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)genericNotificationConfigRepository.findById("config-to-delete")).thenReturn(Optional.empty());
        GenericNotificationConfig foundCfg = new GenericNotificationConfig();
        foundCfg.setId("notif-to-find");
        foundCfg.setName("notif-to-find");
        foundCfg.setReferenceType(NotificationReferenceType.API);
        foundCfg.setReferenceId("config-to-find");
        foundCfg.setNotifier("notifierId");
        foundCfg.setConfig("my config");
        foundCfg.setUseSystemProxy(true);
        foundCfg.setHooks(Arrays.asList("A", "B"));
        foundCfg.setUpdatedAt(new Date(1439022010883L));
        foundCfg.setCreatedAt(new Date(1439022010883L));
        Mockito.when((Object)genericNotificationConfigRepository.findById("notif-to-find")).thenReturn(Optional.of(foundCfg));
        Mockito.when((Object)genericNotificationConfigRepository.findById("notifierId-unknown")).thenReturn(Optional.empty());
        GenericNotificationConfig n1 = (GenericNotificationConfig)Mockito.mock(GenericNotificationConfig.class);
        Mockito.when((Object)n1.getNotifier()).thenReturn((Object)"notifierA");
        GenericNotificationConfig n2 = (GenericNotificationConfig)Mockito.mock(GenericNotificationConfig.class);
        Mockito.when((Object)n2.getNotifier()).thenReturn((Object)"notifierB");
        Mockito.when((Object)genericNotificationConfigRepository.findByReferenceAndHook("B", NotificationReferenceType.APPLICATION, "search")).thenReturn(Arrays.asList(n1, n2));
    }
}

