/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.GroupEventRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class GroupRepositoryMock
extends AbstractRepositoryMock<GroupRepository> {
    public GroupRepositoryMock() {
        super(GroupRepository.class);
    }

    @Override
    void prepare(GroupRepository groupRepository) throws Exception {
        Group createGroup = new Group();
        createGroup.setId("1");
        createGroup.setEnvironmentId("DEFAULT");
        createGroup.setName("my group");
        createGroup.setLockApiRole(true);
        createGroup.setLockApplicationRole(true);
        createGroup.setSystemInvitation(true);
        createGroup.setEmailInvitation(true);
        createGroup.setMaxInvitation(Integer.valueOf(10));
        createGroup.setDisableMembershipNotifications(true);
        Mockito.when((Object)groupRepository.create(Mockito.any())).thenReturn((Object)createGroup);
        Group group_application_1 = new Group();
        group_application_1.setId("group-application-1");
        group_application_1.setEnvironmentId("group-application-1 environment-id");
        group_application_1.setName("group-application-1 name");
        group_application_1.setLockApiRole(true);
        group_application_1.setLockApplicationRole(true);
        group_application_1.setSystemInvitation(true);
        group_application_1.setEmailInvitation(true);
        group_application_1.setDisableMembershipNotifications(true);
        group_application_1.setMaxInvitation(Integer.valueOf(99));
        GroupEventRule eventRule1 = new GroupEventRule();
        eventRule1.setEvent(GroupEvent.API_CREATE);
        GroupEventRule eventRule2 = new GroupEventRule();
        eventRule2.setEvent(GroupEvent.APPLICATION_CREATE);
        group_application_1.setEventRules(Arrays.asList(eventRule1, eventRule2));
        Group group_api_to_delete = new Group();
        group_api_to_delete.setId("group-api-to-delete");
        group_api_to_delete.setName("group-api-to-delete");
        Group group_updated = new Group();
        group_updated.setId("group-application-1");
        group_updated.setName("Modified Name");
        group_updated.setEnvironmentId("new_DEFAULT");
        group_updated.setUpdatedAt(new Date(1000000000000L));
        group_updated.setLockApiRole(true);
        group_updated.setLockApplicationRole(true);
        group_updated.setSystemInvitation(true);
        group_updated.setEmailInvitation(true);
        group_updated.setDisableMembershipNotifications(false);
        group_updated.setMaxInvitation(Integer.valueOf(99));
        Mockito.when((Object)groupRepository.findAll()).thenReturn((Object)Sets.newSet((Object[])new Group[]{group_application_1, group_api_to_delete}));
        Mockito.when((Object)groupRepository.findAllByEnvironment("DEFAULT")).thenReturn((Object)Sets.newSet((Object[])new Group[]{createGroup}));
        Mockito.when((Object)groupRepository.findById((Object)"group-application-1")).thenReturn(Optional.of(group_application_1));
        Mockito.when((Object)groupRepository.findById((Object)"unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)groupRepository.findById((Object)"group-api-to-delete")).thenReturn(Optional.empty());
        Mockito.when((Object)groupRepository.update(Matchers.argThat(o -> o != null && o.getId().equals("unknown")))).thenThrow(new Throwable[]{new TechnicalException()});
        Mockito.when((Object)groupRepository.update(Matchers.argThat(o -> o != null && o.getId().equals("group-application-1")))).thenReturn((Object)group_updated);
        Mockito.when((Object)groupRepository.findByIds(new HashSet<String>(Arrays.asList("group-application-1", "group-api-to-delete", "unknown")))).thenReturn(new HashSet<Group>(Arrays.asList(group_application_1, group_api_to_delete)));
        Mockito.when((Object)groupRepository.findByIds(Collections.emptySet())).thenReturn(Collections.emptySet());
        Mockito.when((Object)groupRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

