/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.IdentityProviderActivationRepository;
import io.gravitee.repository.management.model.IdentityProviderActivation;
import io.gravitee.repository.management.model.IdentityProviderActivationReferenceType;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class IdentityProviderActivationRepositoryMock
extends AbstractRepositoryMock<IdentityProviderActivationRepository> {
    public IdentityProviderActivationRepositoryMock() {
        super(IdentityProviderActivationRepository.class);
    }

    @Override
    void prepare(IdentityProviderActivationRepository identityProviderActivationRepository) throws Exception {
        IdentityProviderActivation githubDefaultEnv = this.createMock("github", "DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT, 1000000000000L);
        IdentityProviderActivation googleDefaultEnv = this.createMock("google", "DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT, 1100000000000L);
        IdentityProviderActivation oidcDefaultEnv = this.createMock("oidc", "DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT, 1200000000000L);
        IdentityProviderActivation oidcDefaultOrg = this.createMock("oidc", "DEFAULT", IdentityProviderActivationReferenceType.ORGANIZATION, 1300000000000L);
        IdentityProviderActivation googleDEVDevEnv = this.createMock("google_DEV", "DEV", IdentityProviderActivationReferenceType.ENVIRONMENT, 1400000000000L);
        IdentityProviderActivation newIdpActDefaultEnv = this.createMock("new-idp-act", "DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT, 1000000000000L);
        Set identityProviderActivations = Sets.newSet((Object[])new IdentityProviderActivation[]{githubDefaultEnv, googleDefaultEnv, oidcDefaultEnv, oidcDefaultOrg, googleDEVDevEnv});
        Set identityProviderActivationsAfterDeleteById = Sets.newSet((Object[])new IdentityProviderActivation[]{githubDefaultEnv, googleDefaultEnv, oidcDefaultEnv, oidcDefaultOrg});
        Set identityProviderActivationsAfterDeleteByIdp = Sets.newSet((Object[])new IdentityProviderActivation[]{githubDefaultEnv, googleDefaultEnv, googleDEVDevEnv});
        Set identityProviderActivationsAfterDeleteByRef = Sets.newSet((Object[])new IdentityProviderActivation[]{oidcDefaultOrg, googleDEVDevEnv});
        Set identityProviderActivationsAfterAdd = Sets.newSet((Object[])new IdentityProviderActivation[]{githubDefaultEnv, googleDefaultEnv, oidcDefaultEnv, oidcDefaultOrg, googleDEVDevEnv, newIdpActDefaultEnv});
        Mockito.when((Object)identityProviderActivationRepository.findAll()).thenReturn((Object)identityProviderActivations, (Object[])new Set[]{identityProviderActivationsAfterAdd, identityProviderActivations, identityProviderActivationsAfterDeleteById, identityProviderActivations, identityProviderActivationsAfterDeleteByIdp, identityProviderActivations, identityProviderActivationsAfterDeleteByRef, identityProviderActivations});
        Mockito.when((Object)identityProviderActivationRepository.create((IdentityProviderActivation)ArgumentMatchers.any(IdentityProviderActivation.class))).thenReturn((Object)newIdpActDefaultEnv);
        Mockito.when((Object)identityProviderActivationRepository.findAllByIdentityProviderId("new-idp-act")).thenReturn((Object)Sets.newSet((Object[])new IdentityProviderActivation[]{newIdpActDefaultEnv}));
        Mockito.when((Object)identityProviderActivationRepository.findAllByIdentityProviderId("github")).thenReturn((Object)Sets.newSet((Object[])new IdentityProviderActivation[]{githubDefaultEnv}));
        Mockito.when((Object)identityProviderActivationRepository.findAllByIdentityProviderId("oidc")).thenReturn((Object)Sets.newSet((Object[])new IdentityProviderActivation[]{oidcDefaultEnv, oidcDefaultOrg}));
        Mockito.when((Object)identityProviderActivationRepository.findAllByReferenceIdAndReferenceType("DEFAULT", IdentityProviderActivationReferenceType.ORGANIZATION)).thenReturn((Object)Sets.newSet((Object[])new IdentityProviderActivation[]{oidcDefaultOrg}));
        Mockito.when((Object)identityProviderActivationRepository.findById("github", "DEFAULT", IdentityProviderActivationReferenceType.ENVIRONMENT)).thenReturn(Optional.of(githubDefaultEnv));
    }

    private IdentityProviderActivation createMock(String idpId, String refId, IdentityProviderActivationReferenceType refType, long createdAtTimestamp) {
        IdentityProviderActivation ipa = new IdentityProviderActivation();
        ipa.setIdentityProviderId(idpId);
        ipa.setReferenceId(refId);
        ipa.setReferenceType(refType);
        ipa.setCreatedAt(new Date(createdAtTimestamp));
        return ipa;
    }
}

