/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.IdentityProviderType;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class IdentityProviderRepositoryMock
extends AbstractRepositoryMock<IdentityProviderRepository> {
    public IdentityProviderRepositoryMock() {
        super(IdentityProviderRepository.class);
    }

    @Override
    void prepare(IdentityProviderRepository identityProviderRepository) throws Exception {
        HashMap<String, String[]> groupMappings = new HashMap<String, String[]>();
        groupMappings.put("{#jsonPath('$.email_verified')}", new String[]{"group1, group2"});
        IdentityProvider newIdentityProvider = (IdentityProvider)Mockito.mock(IdentityProvider.class);
        Mockito.when((Object)newIdentityProvider.getName()).thenReturn((Object)"My idp 1");
        Mockito.when((Object)newIdentityProvider.getOrganizationId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)newIdentityProvider.getDescription()).thenReturn((Object)"Description for my idp 1");
        Mockito.when((Object)newIdentityProvider.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)newIdentityProvider.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)newIdentityProvider.getUpdatedAt()).thenReturn((Object)new Date(1439032010883L));
        Mockito.when((Object)newIdentityProvider.getType()).thenReturn((Object)IdentityProviderType.GITHUB);
        Mockito.when((Object)newIdentityProvider.getEmailRequired()).thenReturn((Object)true);
        Mockito.when((Object)newIdentityProvider.getSyncMappings()).thenReturn((Object)true);
        Mockito.when((Object)newIdentityProvider.getGroupMappings()).thenReturn(groupMappings);
        IdentityProvider identityProvider1 = new IdentityProvider();
        identityProvider1.setId("github");
        identityProvider1.setOrganizationId("DEFAULT");
        identityProvider1.setEnabled(true);
        identityProvider1.setName("Google");
        identityProvider1.setDescription("GitHub Identity Provider");
        identityProvider1.setType(IdentityProviderType.OIDC);
        identityProvider1.setCreatedAt(new Date(1000000000000L));
        identityProvider1.setUpdatedAt(new Date(1486771200000L));
        identityProvider1.setGroupMappings(groupMappings);
        IdentityProvider identityProviderUpdated = (IdentityProvider)Mockito.mock(IdentityProvider.class);
        Mockito.when((Object)identityProviderUpdated.getName()).thenReturn((Object)"Google");
        Mockito.when((Object)identityProviderUpdated.getOrganizationId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)identityProviderUpdated.getDescription()).thenReturn((Object)"Google Identity Provider");
        Mockito.when((Object)identityProviderUpdated.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)identityProviderUpdated.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)identityProviderUpdated.getType()).thenReturn((Object)IdentityProviderType.GOOGLE);
        Mockito.when((Object)identityProviderUpdated.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)identityProviderUpdated.getEmailRequired()).thenReturn((Object)true);
        Mockito.when((Object)identityProviderUpdated.getSyncMappings()).thenReturn((Object)true);
        Mockito.when((Object)identityProviderUpdated.getGroupMappings()).thenReturn(groupMappings);
        IdentityProvider identityProvider3 = this.createMock();
        Set identityProviders = Sets.newSet((Object[])new IdentityProvider[]{newIdentityProvider, identityProvider1, (IdentityProvider)Mockito.mock(IdentityProvider.class)});
        Set identityProvidersAfterDelete = Sets.newSet((Object[])new IdentityProvider[]{newIdentityProvider, identityProvider1});
        Set identityProvidersAfterAdd = Sets.newSet((Object[])new IdentityProvider[]{newIdentityProvider, identityProvider1, (IdentityProvider)Mockito.mock(IdentityProvider.class), (IdentityProvider)Mockito.mock(IdentityProvider.class)});
        Set identityProvidersByEnv = Sets.newSet((Object[])new IdentityProvider[]{newIdentityProvider, identityProvider1, identityProviderUpdated});
        Mockito.when((Object)identityProviderRepository.findAll()).thenReturn((Object)identityProviders, (Object[])new Set[]{identityProvidersAfterAdd, identityProviders, identityProvidersAfterDelete, identityProviders});
        Mockito.when((Object)identityProviderRepository.findAllByOrganizationId("DEFAULT")).thenReturn((Object)identityProvidersByEnv);
        Mockito.when((Object)identityProviderRepository.create((IdentityProvider)ArgumentMatchers.any(IdentityProvider.class))).thenReturn((Object)newIdentityProvider);
        Mockito.when((Object)identityProviderRepository.findById("new-idp")).thenReturn(Optional.of(newIdentityProvider));
        Mockito.when((Object)identityProviderRepository.findById("unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)identityProviderRepository.findById("idp-1")).thenReturn(Optional.of(identityProvider1), (Object[])new Optional[]{Optional.of(identityProviderUpdated)});
        Mockito.when((Object)identityProviderRepository.findById("idp-3")).thenReturn(Optional.of(identityProvider3));
        Mockito.when((Object)identityProviderRepository.update((IdentityProvider)ArgumentMatchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }

    private IdentityProvider createMock() {
        IdentityProvider identityProvider3 = new IdentityProvider();
        identityProvider3.setId("idp-3");
        identityProvider3.setOrganizationId("DEFAULT");
        identityProvider3.setEnabled(false);
        identityProvider3.setName("Gravitee.io AM");
        identityProvider3.setDescription("Gravitee.io AM Identity Provider");
        identityProvider3.setType(IdentityProviderType.GRAVITEEIO_AM);
        identityProvider3.setCreatedAt(new Date(1000000000000L));
        identityProvider3.setUpdatedAt(new Date(1486771200000L));
        String condition = "{#jsonPath('$.email_verified')}";
        HashMap<String, String[]> groupMappings = new HashMap<String, String[]>();
        groupMappings.put(condition, new String[]{"group1", "group2"});
        identityProvider3.setGroupMappings(groupMappings);
        HashMap<String, String[]> roleMappings = new HashMap<String, String[]>();
        roleMappings.put(condition, new String[]{"role1", "role2"});
        identityProvider3.setRoleMappings(roleMappings);
        HashMap<String, String> userProfileMapping = new HashMap<String, String>();
        userProfileMapping.put("sub", "id");
        userProfileMapping.put("firstname", "firstname");
        userProfileMapping.put("email", "mail");
        identityProvider3.setUserProfileMapping(userProfileMapping);
        return identityProvider3;
    }
}

