/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.InvitationRepository;
import io.gravitee.repository.management.model.Invitation;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class InvitationRepositoryMock
extends AbstractRepositoryMock<InvitationRepository> {
    public InvitationRepositoryMock() {
        super(InvitationRepository.class);
    }

    @Override
    void prepare(InvitationRepository invitationRepository) throws Exception {
        Date date = new Date(1439022010883L);
        Invitation invitation = new Invitation();
        invitation.setId("new-invitation");
        invitation.setReferenceType("API");
        invitation.setReferenceId("api-id");
        invitation.setApiRole("USER");
        invitation.setApplicationRole("OWNER");
        invitation.setEmail("new-invitation@email.com");
        invitation.setCreatedAt(date);
        invitation.setUpdatedAt(date);
        Invitation invitation2 = new Invitation();
        invitation2.setId("invitation");
        invitation2.setEmail("invitation@email.com");
        Invitation invitationBeforUpdate = new Invitation();
        invitationBeforUpdate.setId("ec48086d-0bfb-4b9a-a641-d374c6465dd4");
        invitationBeforUpdate.setEmail("invitation@application.com");
        Invitation invitation2Updated = new Invitation();
        invitation2Updated.setId("ec48086d-0bfb-4b9a-a641-d374c6465dd4");
        invitation2Updated.setReferenceType("New reference type");
        invitation2Updated.setReferenceId("New reference id");
        invitation2Updated.setApiRole("USER");
        invitation2Updated.setApplicationRole("OWNER");
        invitation2Updated.setEmail("new-invitation@application.com");
        invitation2Updated.setCreatedAt(date);
        invitation2Updated.setUpdatedAt(date);
        Invitation invitationApplication = new Invitation();
        invitationApplication.setId("e6d5e6d0-17e9-4606-83c3-cfef8b91d5ce");
        invitationApplication.setReferenceType("APPLICATION");
        invitationApplication.setReferenceId("application-id");
        invitationApplication.setApiRole("USER");
        invitationApplication.setApplicationRole("OWNER");
        invitationApplication.setEmail("invitation@application.com");
        invitationApplication.setCreatedAt(date);
        invitationApplication.setUpdatedAt(date);
        Set invitations = Sets.newSet((Object[])new Invitation[]{invitation, invitationApplication, invitation2Updated});
        Set invitationsAfterDelete = Sets.newSet((Object[])new Invitation[]{invitation, invitationApplication});
        Set invitationsAfterAdd = Sets.newSet((Object[])new Invitation[]{invitation, invitation2, (Invitation)Mockito.mock(Invitation.class), (Invitation)Mockito.mock(Invitation.class)});
        Mockito.when((Object)invitationRepository.findAll()).thenReturn((Object)invitations, (Object[])new Set[]{invitationsAfterAdd, invitations, invitationsAfterDelete, invitations});
        Mockito.when((Object)invitationRepository.create(Matchers.any(Invitation.class))).thenReturn((Object)invitation);
        Mockito.when((Object)invitationRepository.findById((Object)"new-invitation")).thenReturn(Optional.of(invitation));
        Mockito.when((Object)invitationRepository.findById((Object)"e6d5e6d0-17e9-4606-83c3-cfef8b91d5ce")).thenReturn(Optional.of(invitationBeforUpdate), (Object[])new Optional[]{Optional.of(invitation2Updated)});
        Mockito.when((Object)invitationRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)invitationRepository.findByReference("API", "api-id")).thenReturn(Collections.singletonList(invitation));
    }
}

