/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MembershipRepositoryMock
extends AbstractRepositoryMock<MembershipRepository> {
    public MembershipRepositoryMock() {
        super(MembershipRepository.class);
    }

    @Override
    void prepare(MembershipRepository membershipRepository) throws Exception {
        String API_OWNER_ROLE = "API_OWNER";
        Membership m1 = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)m1.getId()).thenReturn((Object)"api1_user1");
        Mockito.when((Object)m1.getMemberId()).thenReturn((Object)"user1");
        Mockito.when((Object)m1.getMemberType()).thenReturn((Object)MembershipMemberType.USER);
        Mockito.when((Object)m1.getReferenceType()).thenReturn((Object)MembershipReferenceType.API);
        Mockito.when((Object)m1.getRoleId()).thenReturn((Object)API_OWNER_ROLE);
        Mockito.when((Object)m1.getReferenceId()).thenReturn((Object)"api1");
        Mockito.when((Object)m1.getCreatedAt()).thenReturn((Object)new Date(1439022010883L));
        Mockito.when((Object)m1.getUpdatedAt()).thenReturn((Object)new Date(1439022010883L));
        Mockito.when((Object)m1.getSource()).thenReturn((Object)"myIdp");
        Membership m2 = new Membership("api2_user2", "user2", MembershipMemberType.USER, "api2", MembershipReferenceType.API, API_OWNER_ROLE);
        m2.setId("api2_user2");
        Membership m3 = new Membership("api3_user3", "user3", MembershipMemberType.USER, "api3", MembershipReferenceType.API, "API_USER");
        m3.setId("api3_user3");
        Membership m4 = new Membership("app1_userToDelete", "userToDelete", MembershipMemberType.USER, "app1", MembershipReferenceType.APPLICATION, "APPLICATION_USER");
        m4.setCreatedAt(new Date(1000000000000L));
        Mockito.when((Object)membershipRepository.findById("api1_user1")).thenReturn(Optional.of(m1));
        Mockito.when((Object)membershipRepository.findById("api1")).thenReturn(Optional.empty());
        Mockito.when((Object)membershipRepository.findById("app1_userToDelete")).thenReturn(Optional.empty());
        Mockito.when((Object)membershipRepository.findByReferenceAndRoleId((MembershipReferenceType)Mockito.eq((Object)MembershipReferenceType.API), (String)Mockito.eq((Object)"api1"), (String)Mockito.eq((Object)API_OWNER_ROLE))).thenReturn(Collections.singleton(m1));
        Mockito.when((Object)membershipRepository.findByReferenceAndRoleId((MembershipReferenceType)Mockito.eq((Object)MembershipReferenceType.API), (String)Mockito.eq((Object)"api1"), (String)Mockito.any())).thenReturn(Collections.singleton(m1));
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberTypeAndReferenceType("user1", MembershipMemberType.USER, MembershipReferenceType.API)).thenReturn(Collections.singleton(m1));
        Mockito.when((Object)membershipRepository.findByMemberIdsAndMemberTypeAndReferenceType(Arrays.asList("user2", "user3"), MembershipMemberType.USER, MembershipReferenceType.API)).thenReturn(new HashSet<Membership>(Arrays.asList(m2, m3)));
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndRoleId("user1", MembershipMemberType.USER, MembershipReferenceType.API, API_OWNER_ROLE)).thenReturn(Collections.singleton(m1));
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user1", MembershipMemberType.USER, MembershipReferenceType.API, "api1")).thenReturn(Collections.singleton(m1));
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId("user1", MembershipMemberType.USER, MembershipReferenceType.API, "api1", API_OWNER_ROLE)).thenReturn(Collections.singleton(m1));
        Mockito.when((Object)membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, Arrays.asList("api2", "api3"), API_OWNER_ROLE)).thenReturn(new HashSet<Membership>(Collections.singletonList(m2)));
        Mockito.when((Object)membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, Arrays.asList("api2", "api3"), null)).thenReturn(new HashSet<Membership>(Arrays.asList(m2, m3)));
        Mockito.when((Object)membershipRepository.update((Membership)Mockito.any())).thenReturn((Object)m4);
        Membership api1_findByIds = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)api1_findByIds.getId()).thenReturn((Object)"api1_user_findByIds");
        Membership api2_findByIds = (Membership)Mockito.mock(Membership.class);
        Mockito.when((Object)api2_findByIds.getId()).thenReturn((Object)"api2_user_findByIds");
        Mockito.when((Object)membershipRepository.findByIds(new HashSet<String>(Arrays.asList("api1_user_findByIds", "api2_user_findByIds", "unknown")))).thenReturn(new HashSet<Membership>(Arrays.asList(api1_findByIds, api2_findByIds)));
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberType("user_findByIds", MembershipMemberType.USER)).thenReturn(new HashSet<Membership>(Arrays.asList(api1_findByIds, api2_findByIds)));
        Mockito.when((Object)membershipRepository.update((Membership)Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)membershipRepository.findByRoleId("APPLICATION_USER")).thenReturn(new HashSet<Membership>(Arrays.asList((Membership)Mockito.mock(Membership.class), (Membership)Mockito.mock(Membership.class))));
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user_deleteRef_1", MembershipMemberType.USER, MembershipReferenceType.API, "api_deleteRef")).thenReturn(Collections.singleton(Mockito.mock(Membership.class)), (Object[])new Set[]{Collections.emptySet()});
        Mockito.when((Object)membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId("user_deleteRef_2", MembershipMemberType.USER, MembershipReferenceType.API, "api_deleteRef")).thenReturn(Collections.singleton(Mockito.mock(Membership.class)), (Object[])new Set[]{Collections.emptySet()});
    }
}

