/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.repository.management.model.MetadataReferenceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MetadataRepositoryMock
extends AbstractRepositoryMock<MetadataRepository> {
    public MetadataRepositoryMock() {
        super(MetadataRepository.class);
    }

    @Override
    void prepare(MetadataRepository metadataRepository) throws Exception {
        Metadata booleanMetadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)booleanMetadata.getKey()).thenReturn((Object)"boolean");
        Mockito.when((Object)booleanMetadata.getName()).thenReturn((Object)"Boolean");
        Metadata stringMetadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)stringMetadata.getName()).thenReturn((Object)"Metadata name");
        Mockito.when((Object)stringMetadata.getFormat()).thenReturn((Object)MetadataFormat.STRING);
        Mockito.when((Object)stringMetadata.getValue()).thenReturn((Object)"String");
        Mockito.when((Object)stringMetadata.getKey()).thenReturn((Object)"key");
        Mockito.when((Object)stringMetadata.getReferenceId()).thenReturn((Object)"apiId");
        Mockito.when((Object)stringMetadata.getReferenceType()).thenReturn((Object)MetadataReferenceType.API);
        Metadata metadata2Updated = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)metadata2Updated.getName()).thenReturn((Object)"New metadata");
        Mockito.when((Object)metadata2Updated.getValue()).thenReturn((Object)"New value");
        Mockito.when((Object)metadata2Updated.getFormat()).thenReturn((Object)MetadataFormat.URL);
        Mockito.when((Object)metadata2Updated.getReferenceType()).thenReturn((Object)MetadataReferenceType.APPLICATION);
        List<Metadata> metadataList = Arrays.asList(booleanMetadata, stringMetadata, (Metadata)Mockito.mock(Metadata.class));
        List<Metadata> metadataListAfterAdd = Arrays.asList(booleanMetadata, stringMetadata, (Metadata)Mockito.mock(Metadata.class), (Metadata)Mockito.mock(Metadata.class));
        List<Metadata> metadataListAfterDelete = Arrays.asList(booleanMetadata, stringMetadata);
        Mockito.when((Object)metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT)).thenReturn(metadataList, (Object[])new List[]{metadataListAfterAdd, metadataList, metadataList});
        Mockito.when((Object)metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.APPLICATION, "applicationId")).thenReturn(metadataList, (Object[])new List[]{metadataListAfterDelete});
        Mockito.when((Object)metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.API, "apiId")).thenReturn(Collections.singletonList(stringMetadata));
        Mockito.when((Object)metadataRepository.findByReferenceType(MetadataReferenceType.APPLICATION)).thenReturn(Collections.singletonList(metadata2Updated));
        Mockito.when((Object)metadataRepository.findByKeyAndReferenceType("string", MetadataReferenceType.API)).thenReturn(Collections.singletonList(stringMetadata));
        Mockito.when((Object)metadataRepository.create((Metadata)Mockito.any(Metadata.class))).thenReturn((Object)booleanMetadata);
        Mockito.when((Object)metadataRepository.findById("new-metadata", "_", MetadataReferenceType.DEFAULT)).thenReturn(Optional.of(stringMetadata));
        Mockito.when((Object)metadataRepository.findById("boolean", "_", MetadataReferenceType.DEFAULT)).thenReturn(Optional.of(booleanMetadata), (Object[])new Optional[]{Optional.of(metadata2Updated)});
        Mockito.when((Object)metadataRepository.update((Metadata)Matchers.argThat(o -> o == null || o.getKey().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

