/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.NotificationTemplateRepository;
import io.gravitee.repository.management.model.NotificationTemplate;
import io.gravitee.repository.management.model.NotificationTemplateReferenceType;
import io.gravitee.repository.management.model.NotificationTemplateType;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class NotificationTemplateRepositoryMock
extends AbstractRepositoryMock<NotificationTemplateRepository> {
    public NotificationTemplateRepositoryMock() {
        super(NotificationTemplateRepository.class);
    }

    @Override
    void prepare(NotificationTemplateRepository notificationTemplateRepository) throws Exception {
        NotificationTemplate newNotificationTemplate = (NotificationTemplate)Mockito.mock(NotificationTemplate.class);
        Mockito.when((Object)newNotificationTemplate.getHook()).thenReturn((Object)"MY_NEW_HOOK");
        Mockito.when((Object)newNotificationTemplate.getScope()).thenReturn((Object)"API");
        Mockito.when((Object)newNotificationTemplate.getReferenceId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)newNotificationTemplate.getReferenceType()).thenReturn((Object)NotificationTemplateReferenceType.ORGANIZATION);
        Mockito.when((Object)newNotificationTemplate.getName()).thenReturn((Object)"My notif 1");
        Mockito.when((Object)newNotificationTemplate.getDescription()).thenReturn((Object)"Description for my notif 1");
        Mockito.when((Object)newNotificationTemplate.getTitle()).thenReturn((Object)"Title of my notif");
        Mockito.when((Object)newNotificationTemplate.getContent()).thenReturn((Object)"Content of my notif");
        Mockito.when((Object)newNotificationTemplate.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)newNotificationTemplate.getUpdatedAt()).thenReturn((Object)new Date(1439032010883L));
        Mockito.when((Object)newNotificationTemplate.getType()).thenReturn((Object)NotificationTemplateType.PORTAL);
        Mockito.when((Object)newNotificationTemplate.isEnabled()).thenReturn((Object)true);
        NotificationTemplate notif1 = new NotificationTemplate();
        notif1.setId("notif-1");
        notif1.setName("My notif 1");
        notif1.setDescription("Description for my notif 1");
        notif1.setCreatedAt(new Date(1000000000000L));
        notif1.setUpdatedAt(new Date(1439032010883L));
        NotificationTemplate notificationTemplateUpdated = (NotificationTemplate)Mockito.mock(NotificationTemplate.class);
        Mockito.when((Object)notificationTemplateUpdated.getHook()).thenReturn((Object)"MY_HOOK");
        Mockito.when((Object)notificationTemplateUpdated.getScope()).thenReturn((Object)"API");
        Mockito.when((Object)notificationTemplateUpdated.getReferenceId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)notificationTemplateUpdated.getReferenceType()).thenReturn((Object)NotificationTemplateReferenceType.ORGANIZATION);
        Mockito.when((Object)notificationTemplateUpdated.getName()).thenReturn((Object)"My notif 1");
        Mockito.when((Object)notificationTemplateUpdated.getDescription()).thenReturn((Object)"Description for my notif 1");
        Mockito.when((Object)notificationTemplateUpdated.getTitle()).thenReturn((Object)"Title of my notif");
        Mockito.when((Object)notificationTemplateUpdated.getContent()).thenReturn((Object)"Content of my notif");
        Mockito.when((Object)notificationTemplateUpdated.getCreatedAt()).thenReturn((Object)new Date(1000000000000L));
        Mockito.when((Object)notificationTemplateUpdated.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)notificationTemplateUpdated.getType()).thenReturn((Object)NotificationTemplateType.PORTAL);
        Mockito.when((Object)notificationTemplateUpdated.isEnabled()).thenReturn((Object)true);
        Set notificationTemplates = Sets.newSet((Object[])new NotificationTemplate[]{newNotificationTemplate, notif1, (NotificationTemplate)Mockito.mock(NotificationTemplate.class), (NotificationTemplate)Mockito.mock(NotificationTemplate.class)});
        Set notificationTemplatesAfterDelete = Sets.newSet((Object[])new NotificationTemplate[]{newNotificationTemplate, notif1, (NotificationTemplate)Mockito.mock(NotificationTemplate.class)});
        Set notificationTemplatesAfterAdd = Sets.newSet((Object[])new NotificationTemplate[]{newNotificationTemplate, notif1, (NotificationTemplate)Mockito.mock(NotificationTemplate.class), (NotificationTemplate)Mockito.mock(NotificationTemplate.class), (NotificationTemplate)Mockito.mock(NotificationTemplate.class)});
        Mockito.when((Object)notificationTemplateRepository.findAll()).thenReturn((Object)notificationTemplates, (Object[])new Set[]{notificationTemplatesAfterAdd, notificationTemplates, notificationTemplatesAfterDelete, notificationTemplates});
        Mockito.when((Object)notificationTemplateRepository.findAllByReferenceIdAndReferenceType("DEFAULT", NotificationTemplateReferenceType.ORGANIZATION)).thenReturn((Object)notificationTemplates);
        Mockito.when((Object)notificationTemplateRepository.findByTypeAndReferenceIdAndReferenceType(NotificationTemplateType.PORTAL, "DEFAULT", NotificationTemplateReferenceType.ORGANIZATION)).thenReturn((Object)Sets.newSet((Object[])new NotificationTemplate[]{newNotificationTemplate, notif1, (NotificationTemplate)Mockito.mock(NotificationTemplate.class)}));
        Mockito.when((Object)notificationTemplateRepository.findByHookAndScopeAndReferenceIdAndReferenceType("MY_HOOK_3", "API", "DEFAULT", NotificationTemplateReferenceType.ORGANIZATION)).thenReturn((Object)Sets.newSet((Object[])new NotificationTemplate[]{(NotificationTemplate)Mockito.mock(NotificationTemplate.class), (NotificationTemplate)Mockito.mock(NotificationTemplate.class)}));
        Mockito.when((Object)notificationTemplateRepository.create((NotificationTemplate)Mockito.any(NotificationTemplate.class))).thenReturn((Object)newNotificationTemplate);
        Mockito.when((Object)notificationTemplateRepository.findById("new-notificationTemplate")).thenReturn(Optional.of(newNotificationTemplate));
        Mockito.when((Object)notificationTemplateRepository.findById("unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)notificationTemplateRepository.findById("notif-1")).thenReturn(Optional.of(notif1), (Object[])new Optional[]{Optional.of(notificationTemplateUpdated)});
        Mockito.when((Object)notificationTemplateRepository.update((NotificationTemplate)Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

