/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import java.util.Arrays;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OrganizationRepositoryMock
extends AbstractRepositoryMock<OrganizationRepository> {
    public OrganizationRepositoryMock() {
        super(OrganizationRepository.class);
    }

    @Override
    void prepare(OrganizationRepository organizationRepository) throws Exception {
        Organization orgCreate = new Organization();
        orgCreate.setId("DEFAULT-ORG-create");
        orgCreate.setHrids(Arrays.asList("hrid1", "hrid2"));
        orgCreate.setName("Default org for create");
        orgCreate.setDescription("Default org description for create");
        orgCreate.setDomainRestrictions(Arrays.asList("domain", "restriction"));
        Organization org2Update = new Organization();
        org2Update.setId("DEFAULT-ORG-update");
        org2Update.setName("Default org for update");
        Organization orgUpdated = new Organization();
        orgUpdated.setId("DEFAULT-ORG-update");
        orgUpdated.setName("New name");
        Organization orgDelete = new Organization();
        orgDelete.setId("DEFAULT-ORG-delete");
        orgDelete.setName("Default org for delete");
        Organization orgFindById = new Organization();
        orgFindById.setId("DEFAULT-ORG-findById");
        orgFindById.setName("Default org for findById");
        Mockito.when((Object)organizationRepository.create(ArgumentMatchers.any(Organization.class))).thenReturn((Object)orgCreate);
        Mockito.when((Object)organizationRepository.update(ArgumentMatchers.any(Organization.class))).thenReturn((Object)orgUpdated);
        Mockito.when((Object)organizationRepository.update(ArgumentMatchers.any(Organization.class))).thenReturn((Object)orgUpdated);
        Mockito.when((Object)organizationRepository.findById((Object)"DEFAULT-ORG-create")).thenReturn(Optional.of(orgCreate));
        Mockito.when((Object)organizationRepository.findById((Object)"DEFAULT-ORG-update")).thenReturn(Optional.of(org2Update), (Object[])new Optional[]{Optional.of(orgUpdated)});
        Mockito.when((Object)organizationRepository.findById((Object)"DEFAULT-ORG-delete")).thenReturn(Optional.of(orgDelete), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)organizationRepository.findById((Object)"DEFAULT-ORG-findById")).thenReturn(Optional.of(orgFindById));
        Mockito.when((Object)organizationRepository.count()).thenReturn((Object)3L);
    }
}

