/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.search.PageCriteria;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageMedia;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.management.model.PageSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PageRepositoryMock
extends AbstractRepositoryMock<PageRepository> {
    public PageRepositoryMock() {
        super(PageRepository.class);
    }

    @Override
    void prepare(PageRepository pageRepository) throws Exception {
        Page findApiPage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)findApiPage.getId()).thenReturn((Object)"FindApiPage");
        Mockito.when((Object)findApiPage.getName()).thenReturn((Object)"Find apiPage by apiId or Id");
        Mockito.when((Object)findApiPage.getContent()).thenReturn((Object)"Content of the page");
        Mockito.when((Object)findApiPage.getReferenceId()).thenReturn((Object)"my-api");
        Mockito.when((Object)findApiPage.getReferenceType()).thenReturn((Object)PageReferenceType.API);
        Mockito.when((Object)findApiPage.getType()).thenReturn((Object)"MARKDOWN");
        Mockito.when((Object)findApiPage.getLastContributor()).thenReturn((Object)"john_doe");
        Mockito.when((Object)findApiPage.getOrder()).thenReturn((Object)2);
        Mockito.when((Object)findApiPage.isPublished()).thenReturn((Object)true);
        Mockito.when((Object)findApiPage.getUseAutoFetch()).thenReturn((Object)true);
        PageSource pageSource = new PageSource();
        pageSource.setType("sourceType");
        pageSource.setConfiguration("sourceConfiguration");
        Mockito.when((Object)findApiPage.getSource()).thenReturn((Object)pageSource);
        HashMap<String, String> pageConfiguration = new HashMap<String, String>();
        pageConfiguration.put("tryIt", "true");
        pageConfiguration.put("tryItURL", "http://company.com");
        pageConfiguration.put("showURL", "true");
        pageConfiguration.put("displayOperationId", "true");
        pageConfiguration.put("docExpansion", "FULL");
        pageConfiguration.put("enableFiltering", "true");
        pageConfiguration.put("showExtensions", "true");
        pageConfiguration.put("showCommonExtensions", "true");
        pageConfiguration.put("maxDisplayedTags", "1234");
        Mockito.when((Object)findApiPage.getConfiguration()).thenReturn(pageConfiguration);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("edit_url", "http://provider.com/edit/page");
        metadata.put("size", "256");
        Mockito.when((Object)findApiPage.getMetadata()).thenReturn(metadata);
        Mockito.when((Object)findApiPage.isHomepage()).thenReturn((Object)true);
        Mockito.when((Object)findApiPage.getExcludedGroups()).thenReturn(Arrays.asList("grp1", "grp2"));
        Mockito.when((Object)findApiPage.getAttachedMedia()).thenReturn(Arrays.asList(new PageMedia("media_id_1", "media_name_1", new Date(1586771200000L)), new PageMedia("media_id_2", "media_name_2", new Date(1587771200000L))));
        Mockito.when((Object)findApiPage.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)findApiPage.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o == null || o.getReferenceId().equals("my-api") && o.getReferenceType().equals("API")))).thenReturn(Collections.singletonList(findApiPage));
        ArrayList elevenPages = new ArrayList();
        IntStream.range(0, 11).forEach(__ -> elevenPages.add(findApiPage));
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o != null && o.getReferenceId() == null))).thenReturn(elevenPages);
        Mockito.when((Object)pageRepository.findById("FindApiPage")).thenReturn(Optional.of(findApiPage));
        Page createPage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)createPage.getName()).thenReturn((Object)"Page name");
        Mockito.when((Object)createPage.getContent()).thenReturn((Object)"Page content");
        Mockito.when((Object)createPage.getOrder()).thenReturn((Object)3);
        Mockito.when((Object)createPage.getType()).thenReturn((Object)"MARKDOWN");
        Mockito.when((Object)createPage.isHomepage()).thenReturn((Object)true);
        Mockito.when((Object)createPage.getParentId()).thenReturn((Object)"2");
        Mockito.when((Object)createPage.getUseAutoFetch()).thenReturn((Object)Boolean.FALSE);
        metadata = new HashMap();
        metadata.put("edit_url", "url");
        metadata.put("size", "10");
        Mockito.when((Object)createPage.getConfiguration()).thenReturn(pageConfiguration);
        Mockito.when((Object)createPage.getMetadata()).thenReturn(metadata);
        Mockito.when((Object)pageRepository.findById("new-page")).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(createPage)});
        Page createPageFolder = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)createPageFolder.getName()).thenReturn((Object)"Folder name");
        Mockito.when((Object)createPageFolder.getContent()).thenReturn(null);
        Mockito.when((Object)createPageFolder.getOrder()).thenReturn((Object)3);
        Mockito.when((Object)createPageFolder.getType()).thenReturn((Object)"FOLDER");
        Mockito.when((Object)createPageFolder.isHomepage()).thenReturn((Object)false);
        Mockito.when((Object)createPageFolder.getParentId()).thenReturn((Object)"");
        Mockito.when((Object)pageRepository.findById("new-page-folder")).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(createPageFolder)});
        Page createPortalPage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)createPortalPage.getName()).thenReturn((Object)"Page name");
        Mockito.when((Object)createPortalPage.getContent()).thenReturn((Object)"Page content");
        Mockito.when((Object)createPortalPage.getOrder()).thenReturn((Object)3);
        Mockito.when((Object)createPortalPage.getType()).thenReturn((Object)"MARKDOWN");
        Mockito.when((Object)createPortalPage.isHomepage()).thenReturn((Object)false);
        Mockito.when((Object)createPortalPage.getParentId()).thenReturn((Object)"2");
        metadata = new HashMap();
        metadata.put("edit_url", "url");
        metadata.put("size", "10");
        Mockito.when((Object)createPortalPage.getConfiguration()).thenReturn(pageConfiguration);
        Mockito.when((Object)createPortalPage.getMetadata()).thenReturn(metadata);
        Mockito.when((Object)pageRepository.findById("new-portal-page")).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(createPortalPage)});
        Page createPortalPageFolder = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)createPortalPageFolder.getName()).thenReturn((Object)"Folder name");
        Mockito.when((Object)createPortalPageFolder.getContent()).thenReturn(null);
        Mockito.when((Object)createPortalPageFolder.getOrder()).thenReturn((Object)3);
        Mockito.when((Object)createPortalPageFolder.getType()).thenReturn((Object)"FOLDER");
        Mockito.when((Object)createPortalPageFolder.isHomepage()).thenReturn((Object)false);
        Mockito.when((Object)createPortalPageFolder.getParentId()).thenReturn((Object)"");
        Mockito.when((Object)createPortalPageFolder.getUseAutoFetch()).thenReturn((Object)false);
        Mockito.when((Object)pageRepository.findById("new-portal-page-folder")).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(createPortalPageFolder)});
        Mockito.when((Object)pageRepository.findById("page-to-be-deleted")).thenReturn(Optional.of(Mockito.mock(Page.class)), (Object[])new Optional[]{Optional.empty()});
        Page updatePageBefore = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)updatePageBefore.getId()).thenReturn((Object)"updatePage");
        Mockito.when((Object)updatePageBefore.getName()).thenReturn((Object)"Update Page");
        Mockito.when((Object)updatePageBefore.getContent()).thenReturn((Object)"Content of the update page");
        Mockito.when((Object)updatePageBefore.getConfiguration()).thenReturn(new HashMap());
        Page updatePageAfter = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)updatePageAfter.getId()).thenReturn((Object)"updatePage");
        Mockito.when((Object)updatePageAfter.getName()).thenReturn((Object)"New name");
        Mockito.when((Object)updatePageAfter.getContent()).thenReturn((Object)"New content");
        Mockito.when((Object)updatePageAfter.getReferenceId()).thenReturn((Object)"my-api-2");
        Mockito.when((Object)updatePageAfter.getReferenceType()).thenReturn((Object)PageReferenceType.API);
        Mockito.when((Object)updatePageAfter.getType()).thenReturn((Object)"SWAGGER");
        Mockito.when((Object)updatePageAfter.getOrder()).thenReturn((Object)1);
        Mockito.when((Object)updatePageAfter.getUpdatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)updatePageAfter.getCreatedAt()).thenReturn((Object)new Date(1486772200000L));
        Mockito.when((Object)updatePageAfter.getParentId()).thenReturn((Object)"parent-123");
        Mockito.when((Object)updatePageAfter.isHomepage()).thenReturn((Object)true);
        Mockito.when((Object)updatePageAfter.getExcludedGroups()).thenReturn(Collections.singletonList("excluded"));
        Mockito.when((Object)updatePageAfter.getAttachedMedia()).thenReturn(Collections.singletonList(new PageMedia("media_id", "media_name", new Date(1586771200000L))));
        Mockito.when((Object)updatePageAfter.getLastContributor()).thenReturn((Object)"me");
        Mockito.when((Object)updatePageAfter.isPublished()).thenReturn((Object)true);
        Map pageConfigurationMock = (Map)Mockito.mock(HashMap.class);
        Mockito.when(pageConfigurationMock.get("tryIt")).thenReturn((Object)"true");
        Mockito.when(pageConfigurationMock.get("tryItURL")).thenReturn((Object)"http://company.com");
        Mockito.when(pageConfigurationMock.get("showURL")).thenReturn((Object)"true");
        Mockito.when(pageConfigurationMock.get("displayOperationId")).thenReturn((Object)"true");
        Mockito.when(pageConfigurationMock.get("docExpansion")).thenReturn((Object)"FULL");
        Mockito.when(pageConfigurationMock.get("enableFiltering")).thenReturn((Object)"true");
        Mockito.when(pageConfigurationMock.get("showExtensions")).thenReturn((Object)"true");
        Mockito.when(pageConfigurationMock.get("showCommonExtensions")).thenReturn((Object)"true");
        Mockito.when(pageConfigurationMock.get("maxDisplayedTags")).thenReturn((Object)"1234");
        Mockito.when((Object)updatePageAfter.getConfiguration()).thenReturn((Object)pageConfigurationMock);
        metadata = new HashMap();
        metadata.put("edit_url", "url");
        metadata.put("size", "10");
        Mockito.when((Object)updatePageAfter.getMetadata()).thenReturn(metadata);
        Mockito.when((Object)pageRepository.findById("updatePage")).thenReturn(Optional.of(updatePageBefore), (Object[])new Optional[]{Optional.of(updatePageAfter)});
        Mockito.when((Object)pageRepository.update((Page)Matchers.argThat(o -> o != null && o.getId().equals("updatePage")))).thenReturn((Object)updatePageAfter);
        Page updatePageFolderBefore = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)updatePageFolderBefore.getId()).thenReturn((Object)"updatePageFolder");
        Mockito.when((Object)updatePageFolderBefore.getName()).thenReturn((Object)"Update Page Folder");
        Mockito.when((Object)updatePageFolderBefore.getContent()).thenReturn((Object)"Content of the update page folder");
        Mockito.when((Object)updatePageFolderBefore.getParentId()).thenReturn((Object)"2");
        Mockito.when((Object)updatePageFolderBefore.getReferenceType()).thenReturn((Object)PageReferenceType.API);
        Mockito.when((Object)updatePageFolderBefore.getReferenceId()).thenReturn((Object)"my-api-3");
        Page updatePageFolderAfter = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)updatePageFolderAfter.getId()).thenReturn((Object)"updatePageFolder");
        Mockito.when((Object)updatePageFolderAfter.getName()).thenReturn((Object)"New name page folder");
        Mockito.when((Object)updatePageFolderAfter.getContent()).thenReturn((Object)"New content page folder");
        Mockito.when((Object)updatePageFolderAfter.getParentId()).thenReturn((Object)"3");
        Mockito.when((Object)updatePageFolderAfter.getReferenceType()).thenReturn((Object)PageReferenceType.API);
        Mockito.when((Object)updatePageFolderAfter.getReferenceId()).thenReturn((Object)"my-api-3");
        Mockito.when((Object)pageRepository.findById("updatePageFolder")).thenReturn(Optional.of(updatePageFolderBefore), (Object[])new Optional[]{Optional.of(updatePageFolderAfter)});
        Mockito.when((Object)pageRepository.update((Page)Matchers.argThat(o -> o != null && o.getId().equals("updatePageFolder")))).thenReturn((Object)updatePageFolderAfter);
        Mockito.when((Object)pageRepository.update((Page)Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Page homepage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)homepage.getId()).thenReturn((Object)"home");
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o == null || "my-api-2".equals(o.getReferenceId()) && "API".equals(o.getReferenceType()) && o.getHomepage().equals(Boolean.TRUE)))).thenReturn(Collections.singletonList(homepage));
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o == null || "my-api-2".equals(o.getReferenceId()) && "API".equals(o.getReferenceType()) && o.getHomepage().equals(Boolean.FALSE)))).thenReturn(Arrays.asList((Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class)));
        Page portalHomepage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)portalHomepage.getId()).thenReturn((Object)"FindPortalPage-homepage");
        Page portalNotHomepage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)portalNotHomepage.getId()).thenReturn((Object)"FindPortalPage-nothomepage");
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o == null || "DEFAULT".equals(o.getReferenceId()) && "ENVIRONMENT".equals(o.getReferenceType())))).thenReturn(Arrays.asList(portalHomepage, portalNotHomepage));
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o == null || "DEFAULT".equals(o.getReferenceId()) && "ENVIRONMENT".equals(o.getReferenceType()) && o.getHomepage() != null && o.getHomepage().equals(Boolean.TRUE)))).thenReturn(Collections.singletonList(portalHomepage));
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o == null || "DEFAULT".equals(o.getReferenceId()) && "ENVIRONMENT".equals(o.getReferenceType()) && o.getHomepage() != null && o.getHomepage().equals(Boolean.FALSE)))).thenReturn(Collections.singletonList(portalNotHomepage));
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(o -> o != null && o.getReferenceId() == null && o.getReferenceType() == null && o.getHomepage() == null))).thenReturn(Arrays.asList(findApiPage, (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class), (Page)Mockito.mock(Page.class)));
        Mockito.when((Object)pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder("my-api-2", PageReferenceType.API)).thenReturn((Object)2);
        Mockito.when((Object)pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder("unknown api id", PageReferenceType.API)).thenReturn((Object)0);
        Mockito.when((Object)pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder("DEFAULT", PageReferenceType.ENVIRONMENT)).thenReturn((Object)20);
        final List findAllPages = IntStream.range(0, 10).mapToObj(i -> {
            Page page = (Page)Mockito.mock(Page.class);
            Mockito.when((Object)page.getId()).thenReturn((Object)("pageid" + i));
            return page;
        }).collect(Collectors.toList());
        findAllPages.add(findApiPage);
        Mockito.when((Object)pageRepository.findAll((Pageable)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<io.gravitee.common.data.domain.Page>(){

            public io.gravitee.common.data.domain.Page answer(InvocationOnMock invocation) {
                Pageable pageable = (Pageable)invocation.getArgument(0);
                if (pageable.pageSize() == 100) {
                    return new io.gravitee.common.data.domain.Page(findAllPages, 1, 11, 11L);
                }
                return new io.gravitee.common.data.domain.Page(Arrays.asList((Page)findAllPages.get(pageable.pageNumber())), pageable.pageNumber(), 1, 11L);
            }
        });
        Mockito.when((Object)pageRepository.search((PageCriteria)Matchers.argThat(criteria -> criteria != null && Boolean.TRUE.equals(criteria.getUseAutoFetch())))).thenReturn(Arrays.asList(findApiPage));
    }
}

