/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.PageRevisionRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.PageRevision;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PageRevisionRepositoryMock
extends AbstractRepositoryMock<PageRevisionRepository> {
    public PageRevisionRepositoryMock() {
        super(PageRevisionRepository.class);
    }

    @Override
    void prepare(PageRevisionRepository pageRepository) throws Exception {
        final List findAllPages = IntStream.range(0, 6).mapToObj(i -> {
            PageRevision pagerevision = (PageRevision)Mockito.mock(PageRevision.class);
            Mockito.when((Object)pagerevision.getPageId()).thenReturn((Object)"pageid");
            Mockito.when((Object)pagerevision.getRevision()).thenReturn((Object)i);
            return pagerevision;
        }).collect(Collectors.toList());
        Mockito.when((Object)pageRepository.findAll((Pageable)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Page>(){

            public Page answer(InvocationOnMock invocation) {
                Pageable pageable = (Pageable)invocation.getArgument(0);
                if (pageable.pageSize() != 3) {
                    return new Page(findAllPages, pageable.pageNumber(), 6, 6L);
                }
                return new Page(findAllPages.subList(pageable.from(), (pageable.pageNumber() + 1) * pageable.pageSize()), pageable.pageNumber(), pageable.pageSize(), 6L);
            }
        });
        PageRevision findApiPage = (PageRevision)Mockito.mock(PageRevision.class);
        Mockito.when((Object)findApiPage.getPageId()).thenReturn((Object)"FindApiPage");
        Mockito.when((Object)findApiPage.getRevision()).thenReturn((Object)1);
        Mockito.when((Object)findApiPage.getContributor()).thenReturn((Object)"john_doe");
        Mockito.when((Object)findApiPage.getName()).thenReturn((Object)"Find apiPage by apiId or Id");
        Mockito.when((Object)findApiPage.getContent()).thenReturn((Object)"Content of the page");
        Mockito.when((Object)findApiPage.getHash()).thenReturn((Object)"hexstring");
        Mockito.when((Object)findApiPage.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)pageRepository.findById("FindApiPage", 1)).thenReturn(Optional.of(findApiPage));
        PageRevision createPage = (PageRevision)Mockito.mock(PageRevision.class);
        Mockito.when((Object)createPage.getName()).thenReturn((Object)"Page name");
        Mockito.when((Object)createPage.getContent()).thenReturn((Object)"Page content");
        Mockito.when((Object)createPage.getPageId()).thenReturn((Object)"new-page");
        Mockito.when((Object)createPage.getRevision()).thenReturn((Object)5);
        Mockito.when((Object)createPage.getHash()).thenReturn((Object)"54646446654");
        Mockito.when((Object)pageRepository.findById("new-page", 5)).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(createPage)});
        PageRevision rev = (PageRevision)Mockito.mock(PageRevision.class);
        Mockito.when((Object)rev.getPageId()).thenReturn((Object)"findByPageId");
        Mockito.when((Object)pageRepository.findAllByPageId("findByPageId")).thenReturn(Arrays.asList(rev, rev, rev));
        Mockito.when((Object)pageRepository.findAllByPageId("findByPageId_unknown")).thenReturn(Collections.emptyList());
        PageRevision lastRev = (PageRevision)Mockito.mock(PageRevision.class);
        Mockito.when((Object)lastRev.getPageId()).thenReturn((Object)"findByPageId");
        Mockito.when((Object)lastRev.getContent()).thenReturn((Object)"lorem ipsum");
        Mockito.when((Object)lastRev.getName()).thenReturn((Object)"revision 3");
        Mockito.when((Object)lastRev.getRevision()).thenReturn((Object)3);
        Mockito.when((Object)pageRepository.findLastByPageId("findByPageId")).thenReturn(Optional.of(lastRev));
        Mockito.when((Object)pageRepository.findLastByPageId("findByPageId_unknown")).thenReturn(Optional.empty());
    }
}

