/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.repository.management.model.ParameterReferenceType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ParameterRepositoryMock
extends AbstractRepositoryMock<ParameterRepository> {
    private static final String REFERENCE_ID = "DEFAULT";
    private static final ParameterReferenceType REFERENCE_TYPE = ParameterReferenceType.ENVIRONMENT;

    public ParameterRepositoryMock() {
        super(ParameterRepository.class);
    }

    @Override
    void prepare(ParameterRepository parameterRepository) throws Exception {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter.getValue()).thenReturn((Object)"Parameter value");
        Mockito.when((Object)parameter.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)parameter.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Parameter parameter2 = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter2.getKey()).thenReturn((Object)"portal.top-apis");
        Mockito.when((Object)parameter2.getValue()).thenReturn((Object)"api1;api2;api2");
        Mockito.when((Object)parameter2.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)parameter2.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Parameter parameter2Updated = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)parameter2Updated.getValue()).thenReturn((Object)"New value");
        Mockito.when((Object)parameter2Updated.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)parameter2Updated.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Mockito.when((Object)parameterRepository.create((Parameter)ArgumentMatchers.any(Parameter.class))).thenReturn((Object)parameter);
        Mockito.when((Object)parameterRepository.findById("new-parameter", REFERENCE_ID, REFERENCE_TYPE)).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(parameter)});
        Mockito.when((Object)parameterRepository.findById("management.oAuth.clientId", REFERENCE_ID, REFERENCE_TYPE)).thenReturn(Optional.of(parameter2), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)parameterRepository.findById("portal.top-apis", REFERENCE_ID, REFERENCE_TYPE)).thenReturn(Optional.of(parameter2), (Object[])new Optional[]{Optional.of(parameter2Updated)});
        Mockito.when((Object)parameterRepository.update((Parameter)ArgumentMatchers.argThat(o -> o == null || o.getKey().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)parameterRepository.findByKeys((List)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ParameterReferenceType)ArgumentMatchers.any())).thenReturn(Arrays.asList((Parameter)Mockito.mock(Parameter.class), (Parameter)Mockito.mock(Parameter.class)));
        Mockito.when((Object)parameterRepository.findAll((String)Mockito.eq((Object)REFERENCE_ID), (ParameterReferenceType)Mockito.eq((Object)REFERENCE_TYPE))).thenReturn(Arrays.asList(parameter, parameter2, parameter2Updated));
    }
}

