/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PlanRepositoryMock
extends AbstractRepositoryMock<PlanRepository> {
    public PlanRepositoryMock() {
        super(PlanRepository.class);
    }

    @Override
    void prepare(PlanRepository planRepository) throws Exception {
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan.getName()).thenReturn((Object)"Plan name");
        Mockito.when((Object)plan.getDescription()).thenReturn((Object)"Description for the new plan");
        Mockito.when((Object)plan.getValidation()).thenReturn((Object)Plan.PlanValidationType.AUTO);
        Mockito.when((Object)plan.getType()).thenReturn((Object)Plan.PlanType.API);
        Mockito.when((Object)plan.getApi()).thenReturn((Object)"my-api");
        Mockito.when((Object)plan.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)plan.getUpdatedAt()).thenReturn((Object)DateUtils.parse("12/02/2016"));
        Mockito.when((Object)plan.getPublishedAt()).thenReturn((Object)DateUtils.parse("13/02/2016"));
        Mockito.when((Object)plan.getClosedAt()).thenReturn((Object)DateUtils.parse("14/02/2016"));
        Mockito.when((Object)plan.getStatus()).thenReturn((Object)Plan.Status.STAGING);
        Mockito.when((Object)plan.getSecurity()).thenReturn((Object)Plan.PlanSecurityType.KEY_LESS);
        Mockito.when((Object)plan.getGeneralConditions()).thenReturn((Object)"general_conditions");
        Plan plan2 = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)plan2.getId()).thenReturn((Object)"my-plan");
        Mockito.when((Object)plan2.getName()).thenReturn((Object)"Free plan");
        Mockito.when((Object)plan2.getDescription()).thenReturn((Object)"Description of the free plan");
        Mockito.when((Object)plan2.getApi()).thenReturn((Object)"api1");
        Mockito.when((Object)plan2.getSecurity()).thenReturn((Object)Plan.PlanSecurityType.API_KEY);
        Mockito.when((Object)plan2.getValidation()).thenReturn((Object)Plan.PlanValidationType.AUTO);
        Mockito.when((Object)plan2.getType()).thenReturn((Object)Plan.PlanType.API);
        Mockito.when((Object)plan2.getStatus()).thenReturn((Object)Plan.Status.PUBLISHED);
        Mockito.when((Object)plan2.getOrder()).thenReturn((Object)2);
        Mockito.when((Object)plan2.getCreatedAt()).thenReturn((Object)new Date(1506964899000L));
        Mockito.when((Object)plan2.getUpdatedAt()).thenReturn((Object)new Date(1507032062000L));
        Mockito.when((Object)plan2.getPublishedAt()).thenReturn((Object)new Date(1506878460000L));
        Mockito.when((Object)plan2.getClosedAt()).thenReturn((Object)new Date(1507611600000L));
        Mockito.when((Object)plan2.getNeedRedeployAt()).thenReturn((Object)new Date(1507611670000L));
        Mockito.when((Object)plan2.getCharacteristics()).thenReturn(Arrays.asList("charac 1", "charac 2"));
        Mockito.when((Object)plan2.getExcludedGroups()).thenReturn(Collections.singletonList("grp1"));
        Mockito.when((Object)plan2.getTags()).thenReturn(new HashSet<String>(Arrays.asList("tag1", "tag2")));
        Mockito.when((Object)plan2.isCommentRequired()).thenReturn((Object)true);
        Mockito.when((Object)plan2.getCommentMessage()).thenReturn((Object)"What is your project code?");
        Mockito.when((Object)plan2.getSelectionRule()).thenReturn(null);
        Mockito.when((Object)plan2.getGeneralConditions()).thenReturn((Object)"GCU-my-plan");
        Plan planOAuth2 = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)planOAuth2.getName()).thenReturn((Object)"Plan oauth2 name");
        Mockito.when((Object)planOAuth2.getDescription()).thenReturn((Object)"Description for the new oauth2 plan");
        Mockito.when((Object)planOAuth2.getValidation()).thenReturn((Object)Plan.PlanValidationType.AUTO);
        Mockito.when((Object)planOAuth2.getType()).thenReturn((Object)Plan.PlanType.API);
        Mockito.when((Object)planOAuth2.getApi()).thenReturn((Object)"my-api");
        Mockito.when((Object)planOAuth2.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)planOAuth2.getUpdatedAt()).thenReturn((Object)DateUtils.parse("12/02/2016"));
        Mockito.when((Object)planOAuth2.getPublishedAt()).thenReturn((Object)DateUtils.parse("13/02/2016"));
        Mockito.when((Object)planOAuth2.getClosedAt()).thenReturn((Object)DateUtils.parse("14/02/2016"));
        Mockito.when((Object)planOAuth2.getStatus()).thenReturn((Object)Plan.Status.STAGING);
        Mockito.when((Object)planOAuth2.getSecurity()).thenReturn((Object)Plan.PlanSecurityType.OAUTH2);
        Mockito.when((Object)planOAuth2.getSecurityDefinition()).thenReturn((Object)"{\"extractPayload\":false,\"checkRequiredScopes\":false,\"requiredScopes\":[],\"oauthResource\":\"OAuth\"}");
        Mockito.when((Object)planOAuth2.isCommentRequired()).thenReturn((Object)true);
        Plan createdPlanOAuth2 = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)createdPlanOAuth2.getId()).thenReturn((Object)"plan-oauth2");
        Mockito.when((Object)createdPlanOAuth2.getName()).thenReturn((Object)"oauth2");
        Mockito.when((Object)createdPlanOAuth2.getDescription()).thenReturn((Object)"Description of oauth2");
        Mockito.when((Object)createdPlanOAuth2.getValidation()).thenReturn((Object)Plan.PlanValidationType.MANUAL);
        Mockito.when((Object)createdPlanOAuth2.getType()).thenReturn((Object)Plan.PlanType.API);
        Mockito.when((Object)createdPlanOAuth2.getApi()).thenReturn((Object)"4e0db366-f772-4489-8db3-66f772b48989");
        Mockito.when((Object)createdPlanOAuth2.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2016"));
        Mockito.when((Object)createdPlanOAuth2.getUpdatedAt()).thenReturn((Object)DateUtils.parse("12/02/2016"));
        Mockito.when((Object)createdPlanOAuth2.getStatus()).thenReturn((Object)Plan.Status.STAGING);
        Mockito.when((Object)createdPlanOAuth2.getOrder()).thenReturn((Object)0);
        Mockito.when((Object)createdPlanOAuth2.getExcludedGroups()).thenReturn(Collections.singletonList("7c546c6b-2f2f-4487-946c-6b2f2f648784"));
        Mockito.when((Object)createdPlanOAuth2.getSecurity()).thenReturn((Object)Plan.PlanSecurityType.OAUTH2);
        Mockito.when((Object)createdPlanOAuth2.getSecurityDefinition()).thenReturn((Object)"{\"extractPayload\":false,\"checkRequiredScopes\":false,\"requiredScopes\":[],\"oauthResource\":\"OAuth\"}");
        Mockito.when((Object)createdPlanOAuth2.getDefinition()).thenReturn((Object)"{  \"/\" : [ {    \"methods\" : [ \"GET\", \"POST\", \"PUT\", \"DELETE\", \"HEAD\", \"PATCH\", \"OPTIONS\", \"TRACE\", \"CONNECT\" ],    \"resource-filtering\" : {\"whitelist\":[{\"pattern\":\"/**\",\"methods\":[\"GET\"]}]},    \"enabled\" : true  } ]}");
        Mockito.when((Object)createdPlanOAuth2.isCommentRequired()).thenReturn((Object)true);
        Mockito.when((Object)createdPlanOAuth2.getSelectionRule()).thenReturn((Object)"#context.attributes['jwt'].claims['iss'] == 'toto'");
        Plan updatedPlan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)updatedPlan.getId()).thenReturn((Object)"updated-plan");
        Mockito.when((Object)updatedPlan.getName()).thenReturn((Object)"New plan");
        Mockito.when((Object)updatedPlan.getDescription()).thenReturn((Object)"New description");
        Mockito.when((Object)updatedPlan.getTags()).thenReturn(Collections.singleton("tag1"));
        Plan updatedOauth2Plan = (Plan)Mockito.mock(Plan.class);
        Mockito.when((Object)updatedOauth2Plan.getId()).thenReturn((Object)"updated-plan-oauth2");
        Mockito.when((Object)updatedOauth2Plan.getName()).thenReturn((Object)"New oauth2 plan");
        Mockito.when((Object)updatedOauth2Plan.getDescription()).thenReturn((Object)"New oauth2 description");
        Mockito.when((Object)planRepository.create(ArgumentMatchers.any(Plan.class))).thenReturn((Object)plan);
        Mockito.when((Object)planRepository.findById((Object)"new-plan")).thenReturn(Optional.of(plan));
        Mockito.when((Object)planRepository.findById((Object)"my-plan")).thenReturn(Optional.of(plan2));
        Mockito.when((Object)planRepository.findById((Object)"new-oauth2-plan")).thenReturn(Optional.of(planOAuth2));
        Mockito.when((Object)planRepository.findById((Object)"plan-oauth2")).thenReturn(Optional.of(createdPlanOAuth2));
        Mockito.when((Object)planRepository.findById((Object)"updated-plan")).thenReturn(Optional.of(updatedPlan));
        Mockito.when((Object)planRepository.findById((Object)"updated-plan-oauth2")).thenReturn(Optional.of(updatedOauth2Plan));
        Mockito.when((Object)planRepository.findById((Object)"stores")).thenReturn(Optional.empty());
        Mockito.when((Object)planRepository.findByApi("api1")).thenReturn(new HashSet<Plan>(Arrays.asList(plan, plan2)));
        Mockito.when((Object)planRepository.findById((Object)"unknown")).thenReturn(Optional.empty());
        Mockito.when((Object)planRepository.update(ArgumentMatchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

