/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.mockito.Mockito;

public class PortalNotificationConfigRepositoryMock
extends AbstractRepositoryMock<PortalNotificationConfigRepository> {
    public PortalNotificationConfigRepositoryMock() {
        super(PortalNotificationConfigRepository.class);
    }

    @Override
    void prepare(PortalNotificationConfigRepository portalNotificationConfigRepository) throws Exception {
        PortalNotificationConfig createdCfg = new PortalNotificationConfig();
        createdCfg.setReferenceType(NotificationReferenceType.API);
        createdCfg.setReferenceId("config-created");
        createdCfg.setUser("userid");
        createdCfg.setHooks(Arrays.asList("A", "B", "C"));
        createdCfg.setUpdatedAt(new Date(1439022010883L));
        createdCfg.setCreatedAt(new Date(1439022010883L));
        Mockito.when((Object)portalNotificationConfigRepository.create((PortalNotificationConfig)Mockito.any())).thenReturn((Object)createdCfg);
        PortalNotificationConfig updatedCfg = new PortalNotificationConfig();
        updatedCfg.setReferenceType(NotificationReferenceType.API);
        updatedCfg.setReferenceId("config-to-update");
        updatedCfg.setUser("userid");
        updatedCfg.setHooks(Arrays.asList("D", "B", "C"));
        updatedCfg.setUpdatedAt(new Date(1479022010883L));
        updatedCfg.setCreatedAt(new Date(1469022010883L));
        Mockito.when((Object)portalNotificationConfigRepository.update((PortalNotificationConfig)Mockito.any())).thenReturn((Object)updatedCfg);
        Mockito.when((Object)portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-delete")).thenReturn(Optional.of(Mockito.mock(PortalNotificationConfig.class)), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)portalNotificationConfigRepository.findById("useridToDelete", NotificationReferenceType.API, "config")).thenReturn(Optional.empty());
        PortalNotificationConfig foundCfg = new PortalNotificationConfig();
        foundCfg.setReferenceType(NotificationReferenceType.API);
        foundCfg.setReferenceId("config-to-find");
        foundCfg.setUser("userid");
        foundCfg.setHooks(Arrays.asList("A", "B"));
        foundCfg.setUpdatedAt(new Date(1439022010883L));
        foundCfg.setCreatedAt(new Date(1439022010883L));
        Mockito.when((Object)portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-find")).thenReturn(Optional.of(foundCfg));
        Mockito.when((Object)portalNotificationConfigRepository.findById("userid-unknown", NotificationReferenceType.API, "config-to-find")).thenReturn(Optional.empty());
        Mockito.when((Object)portalNotificationConfigRepository.findById("userid", NotificationReferenceType.APPLICATION, "config-to-find")).thenReturn(Optional.empty());
        Mockito.when((Object)portalNotificationConfigRepository.findById("userid", NotificationReferenceType.API, "config-to-not-find")).thenReturn(Optional.empty());
        PortalNotificationConfig n1 = (PortalNotificationConfig)Mockito.mock(PortalNotificationConfig.class);
        Mockito.when((Object)n1.getUser()).thenReturn((Object)"userA");
        PortalNotificationConfig n2 = (PortalNotificationConfig)Mockito.mock(PortalNotificationConfig.class);
        Mockito.when((Object)n2.getUser()).thenReturn((Object)"userB");
        Mockito.when((Object)portalNotificationConfigRepository.findByReferenceAndHook("B", NotificationReferenceType.APPLICATION, "search")).thenReturn(Arrays.asList(n1, n2));
        Mockito.when((Object)portalNotificationConfigRepository.findByReferenceAndHook("D", NotificationReferenceType.APPLICATION, "search")).thenReturn(Collections.emptyList());
        Mockito.when((Object)portalNotificationConfigRepository.findById("apiToDelete-1", NotificationReferenceType.API, "apiToDelete")).thenReturn(Optional.of(Mockito.mock(PortalNotificationConfig.class)), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)portalNotificationConfigRepository.findById("apiToDelete-2", NotificationReferenceType.API, "apiToDelete")).thenReturn(Optional.of(Mockito.mock(PortalNotificationConfig.class)), (Object[])new Optional[]{Optional.empty()});
    }
}

