/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.RatingAnswerRepository;
import io.gravitee.repository.management.model.RatingAnswer;
import io.gravitee.repository.utils.DateUtils;
import java.util.Collections;
import java.util.Optional;
import org.mockito.Mockito;

public class RatingAnswerRepositoryMock
extends AbstractRepositoryMock<RatingAnswerRepository> {
    public RatingAnswerRepositoryMock() {
        super(RatingAnswerRepository.class);
    }

    @Override
    void prepare(RatingAnswerRepository ratingAnswerRepository) throws Exception {
        RatingAnswer ratingAnswer = new RatingAnswer();
        ratingAnswer.setId("answer-id");
        ratingAnswer.setRating("rating-id");
        ratingAnswer.setUser("user");
        ratingAnswer.setComment("Answer");
        ratingAnswer.setCreatedAt(DateUtils.parse("11/02/2017"));
        RatingAnswer ratingAnswer2 = new RatingAnswer();
        ratingAnswer2.setId("answer2-id");
        ratingAnswer2.setRating("rating3-id");
        ratingAnswer2.setUser("admin");
        ratingAnswer2.setComment("Answer2");
        ratingAnswer2.setCreatedAt(DateUtils.parse("11/02/2017"));
        RatingAnswer newRatingAnswer = new RatingAnswer();
        newRatingAnswer.setId("new-answer-id");
        newRatingAnswer.setRating("new-rating");
        newRatingAnswer.setUser("user");
        newRatingAnswer.setComment("My answer");
        newRatingAnswer.setCreatedAt(DateUtils.parse("11/02/2017"));
        Mockito.when((Object)ratingAnswerRepository.findByRating("rating-id")).thenReturn(Collections.singletonList(ratingAnswer));
        Mockito.when((Object)ratingAnswerRepository.findByRating("rating3-id")).thenReturn(Collections.singletonList(ratingAnswer2));
        Mockito.when((Object)ratingAnswerRepository.findByRating("new-rating")).thenReturn(Collections.singletonList(newRatingAnswer));
        Mockito.when((Object)ratingAnswerRepository.findById("answer-id")).thenReturn(Optional.of(ratingAnswer), (Object[])new Optional[]{Optional.empty()});
    }
}

