/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.RatingRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.Rating;
import io.gravitee.repository.management.model.RatingReferenceType;
import io.gravitee.repository.utils.DateUtils;
import java.util.Arrays;
import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RatingRepositoryMock
extends AbstractRepositoryMock<RatingRepository> {
    public RatingRepositoryMock() {
        super(RatingRepository.class);
    }

    @Override
    void prepare(RatingRepository ratingRepository) throws Exception {
        Rating rating = this.mockRating("rating-id", "api", RatingReferenceType.API, "user", "title", "My comment", "1");
        Rating rating2 = this.mockRating("rating2-id", "api", RatingReferenceType.API, "toto", "title2", "My comment2", "5");
        Rating rating3 = this.mockRating("rating3-id", "api2", RatingReferenceType.API, "admin", "title3", "My comment3", "2");
        Rating rating4 = this.mockRating("rating4-id", "api", RatingReferenceType.API, "admin", "title4", "My comment4", "2");
        Rating newRating = this.mockRating("new-rating", "api", RatingReferenceType.API, "user", "title", "comment", "5");
        Mockito.when((Object)ratingRepository.findById("rating-id")).thenReturn(Optional.of(rating));
        Mockito.when((Object)ratingRepository.findById("new-rating")).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(newRating)});
        Mockito.when((Object)ratingRepository.findByReferenceIdAndReferenceTypePageable((String)ArgumentMatchers.eq((Object)"api"), (RatingReferenceType)ArgumentMatchers.eq((Object)RatingReferenceType.API), (Pageable)ArgumentMatchers.any(Pageable.class))).thenReturn((Object)new Page(Arrays.asList(rating4, rating), 0, 2, 3L), (Object[])new Page[]{new Page(Arrays.asList(rating2), 1, 1, 3L)});
        Rating updatedRating = this.mockRating("rating-id", "api", RatingReferenceType.API, "user10", "title10", "comment10", "3");
        Mockito.when((Object)ratingRepository.update((Rating)ArgumentMatchers.any(Rating.class))).thenReturn((Object)updatedRating);
        Mockito.when((Object)ratingRepository.findById("rating3-id")).thenReturn(Optional.of(rating3), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)ratingRepository.findByReferenceIdAndReferenceTypeAndUser("api", RatingReferenceType.API, "user")).thenReturn(Optional.of(rating));
        Mockito.when((Object)ratingRepository.findByReferenceIdAndReferenceType("api", RatingReferenceType.API)).thenReturn(Arrays.asList(rating, rating2, rating4));
    }

    private Rating mockRating(String id, String referenceId, RatingReferenceType referenceType, String user, String title, String comment, String rate) {
        Rating rating = (Rating)Mockito.mock(Rating.class);
        Mockito.when((Object)rating.getId()).thenReturn((Object)id);
        Mockito.when((Object)rating.getReferenceId()).thenReturn((Object)referenceId);
        Mockito.when((Object)rating.getReferenceType()).thenReturn((Object)referenceType);
        Mockito.when((Object)rating.getUser()).thenReturn((Object)user);
        Mockito.when((Object)rating.getTitle()).thenReturn((Object)title);
        Mockito.when((Object)rating.getComment()).thenReturn((Object)comment);
        Mockito.when((Object)rating.getRate()).thenReturn((Object)new Byte(rate));
        Mockito.when((Object)rating.getCreatedAt()).thenReturn((Object)DateUtils.parse("11/02/2017"));
        Mockito.when((Object)rating.getUpdatedAt()).thenReturn((Object)DateUtils.parse("11/02/2017"));
        return rating;
    }
}

