/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class RoleRepositoryMock
extends AbstractRepositoryMock<RoleRepository> {
    private static final RoleReferenceType REFERENCE_TYPE = RoleReferenceType.ORGANIZATION;
    private static final String REFERENCE_ID = "DEFAULT";

    public RoleRepositoryMock() {
        super(RoleRepository.class);
    }

    @Override
    void prepare(RoleRepository roleRepository) throws Exception {
        Role toCreate = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)toCreate.getId()).thenReturn((Object)"API_to_create");
        Mockito.when((Object)toCreate.getName()).thenReturn((Object)"to create");
        Mockito.when((Object)toCreate.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)toCreate.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Mockito.when((Object)toCreate.getScope()).thenReturn((Object)RoleScope.API);
        Mockito.when((Object)toCreate.getPermissions()).thenReturn((Object)new int[]{3});
        Role toDelete = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)toDelete.getId()).thenReturn((Object)"ORGANIZATION_to_delete");
        Mockito.when((Object)toDelete.getName()).thenReturn((Object)"to delete");
        Mockito.when((Object)toDelete.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)toDelete.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Mockito.when((Object)toDelete.getScope()).thenReturn((Object)RoleScope.ORGANIZATION);
        Mockito.when((Object)toDelete.getPermissions()).thenReturn((Object)new int[]{1, 2, 3});
        Role toUpdate = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)toUpdate.getId()).thenReturn((Object)"ENVIRONMENT_to_update");
        Mockito.when((Object)toUpdate.getName()).thenReturn((Object)"to update");
        Mockito.when((Object)toUpdate.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)toUpdate.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Mockito.when((Object)toUpdate.getDescription()).thenReturn((Object)"new description");
        Mockito.when((Object)toUpdate.getScope()).thenReturn((Object)RoleScope.ENVIRONMENT);
        Mockito.when((Object)toUpdate.isDefaultRole()).thenReturn((Object)true);
        Mockito.when((Object)toUpdate.getPermissions()).thenReturn((Object)new int[]{4, 5});
        Role findByScope1 = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)findByScope1.getId()).thenReturn((Object)"API_find_by_scope_1");
        Mockito.when((Object)findByScope1.getName()).thenReturn((Object)"find by scope 1");
        Mockito.when((Object)findByScope1.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)findByScope1.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Mockito.when((Object)findByScope1.getDescription()).thenReturn((Object)"role description");
        Mockito.when((Object)findByScope1.getScope()).thenReturn((Object)RoleScope.API);
        Mockito.when((Object)findByScope1.isDefaultRole()).thenReturn((Object)true);
        Mockito.when((Object)findByScope1.isSystem()).thenReturn((Object)true);
        Mockito.when((Object)findByScope1.getPermissions()).thenReturn((Object)new int[]{1});
        Role findByScope2 = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)findByScope2.getId()).thenReturn((Object)"API_find_by_scope_2");
        Mockito.when((Object)findByScope2.getName()).thenReturn((Object)"find by scope 2");
        Mockito.when((Object)findByScope2.getReferenceId()).thenReturn((Object)REFERENCE_ID);
        Mockito.when((Object)findByScope2.getReferenceType()).thenReturn((Object)REFERENCE_TYPE);
        Mockito.when((Object)findByScope2.getScope()).thenReturn((Object)RoleScope.API);
        Mockito.when((Object)findByScope2.isDefaultRole()).thenReturn((Object)false);
        Mockito.when((Object)findByScope2.getPermissions()).thenReturn((Object)new int[]{1});
        Mockito.when((Object)roleRepository.findById("API_find_by_scope_1")).thenReturn(Optional.of(findByScope1));
        Mockito.when((Object)roleRepository.findById("ENVIRONMENT_to_update")).thenReturn(Optional.of(toUpdate));
        Mockito.when((Object)roleRepository.findById("API_to_create")).thenReturn(Optional.empty(), (Object[])new Optional[]{Optional.of(toCreate)});
        Mockito.when((Object)roleRepository.findById("ORGANIZATION_to_delete")).thenReturn(Optional.of(findByScope1), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)roleRepository.findById("API_find_by_scope_2")).thenReturn(Optional.of(findByScope2));
        Mockito.when((Object)roleRepository.create((Role)Mockito.any(Role.class))).thenReturn((Object)toCreate);
        Mockito.when((Object)roleRepository.findAll()).thenReturn((Object)Sets.newSet((Object[])new Role[]{toDelete, toUpdate, findByScope1, findByScope2}));
        Mockito.when((Object)roleRepository.findAllByReferenceIdAndReferenceType(REFERENCE_ID, REFERENCE_TYPE)).thenReturn((Object)Sets.newSet((Object[])new Role[]{toCreate, toDelete, toUpdate}));
        Mockito.when((Object)roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.API, "find by scope 1", REFERENCE_ID, REFERENCE_TYPE)).thenReturn(Optional.of(findByScope1));
        Mockito.when((Object)roleRepository.findByScopeAndReferenceIdAndReferenceType(RoleScope.API, REFERENCE_ID, REFERENCE_TYPE)).thenReturn((Object)Sets.newSet((Object[])new Role[]{findByScope1}));
        Mockito.when((Object)roleRepository.update((Role)Mockito.any())).thenReturn((Object)toUpdate);
        Mockito.when((Object)roleRepository.update((Role)Matchers.argThat(o -> o == null || o.getName().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

