/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Subscription;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SubscriptionRepositoryMock
extends AbstractRepositoryMock<SubscriptionRepository> {
    public SubscriptionRepositoryMock() {
        super(SubscriptionRepository.class);
    }

    @Override
    void prepare(SubscriptionRepository subscriptionRepository) throws Exception {
        Subscription sub1 = new Subscription();
        sub1.setId("sub1");
        sub1.setPlan("plan1");
        sub1.setApplication("app1");
        sub1.setApi("api1");
        sub1.setRequest("request");
        sub1.setReason("reason");
        sub1.setStatus(Subscription.Status.PENDING);
        sub1.setProcessedBy("user1");
        sub1.setSubscribedBy("user2");
        sub1.setStartingAt(new Date(1439022010883L));
        sub1.setEndingAt(new Date(1449022010883L));
        sub1.setCreatedAt(new Date(1459022010883L));
        sub1.setUpdatedAt(new Date(1469022010883L));
        sub1.setProcessedAt(new Date(1479022010883L));
        sub1.setPausedAt(new Date(1479022010883L));
        sub1.setClientId("my-client-id");
        sub1.setGeneralConditionsAccepted(Boolean.valueOf(true));
        sub1.setGeneralConditionsContentPageId("ref");
        sub1.setGeneralConditionsContentRevision(Integer.valueOf(2));
        Subscription sub3 = new Subscription();
        sub3.setId("sub3");
        Subscription sub4 = new Subscription();
        sub4.setId("sub4");
        Mockito.when((Object)subscriptionRepository.search(new SubscriptionCriteria.Builder().plans(Collections.singleton("plan1")).build())).thenReturn(Collections.singletonList(sub1));
        Mockito.when((Object)subscriptionRepository.search(new SubscriptionCriteria.Builder().plans(Collections.singleton("unknown-plan")).build())).thenReturn(Collections.emptyList());
        Mockito.when((Object)subscriptionRepository.search(new SubscriptionCriteria.Builder().applications(Collections.singleton("app1")).build())).thenReturn(Arrays.asList(sub3, sub4, sub1));
        Mockito.when((Object)subscriptionRepository.search(new SubscriptionCriteria.Builder().applications(Collections.singleton("unknown-app")).build())).thenReturn(Collections.emptyList());
        Mockito.when((Object)subscriptionRepository.findById((Object)"sub1")).thenReturn(Optional.of(sub1));
        Mockito.when((Object)subscriptionRepository.findById((Object)"unknown-sub")).thenReturn(Optional.empty());
        Mockito.when((Object)subscriptionRepository.findById((Object)"sub2")).thenReturn(Optional.empty());
        Mockito.when((Object)subscriptionRepository.update((Object)sub1)).thenReturn((Object)sub1);
        Mockito.when((Object)subscriptionRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)subscriptionRepository.search(new SubscriptionCriteria.Builder().from(1469022010883L).to(1569022010883L).build())).thenReturn(Collections.singletonList(sub1));
        Mockito.when((Object)subscriptionRepository.search((SubscriptionCriteria)Mockito.any(), (Pageable)Mockito.eq((Object)new PageableBuilder().pageNumber(0).pageSize(2).build()))).thenReturn((Object)new Page(Arrays.asList(sub3, sub1), 0, 2, 2L));
        Mockito.when((Object)subscriptionRepository.search((SubscriptionCriteria)Mockito.any(), (Pageable)Mockito.eq((Object)new PageableBuilder().pageNumber(1).pageSize(2).build()))).thenReturn((Object)new Page(Collections.emptyList(), 1, 0, 2L));
    }
}

