/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.TagRepository;
import io.gravitee.repository.management.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class TagRepositoryMock
extends AbstractRepositoryMock<TagRepository> {
    public TagRepositoryMock() {
        super(TagRepository.class);
    }

    @Override
    void prepare(TagRepository tagRepository) throws Exception {
        Tag tag = (Tag)Mockito.mock(Tag.class);
        Mockito.when((Object)tag.getName()).thenReturn((Object)"Tag name");
        Mockito.when((Object)tag.getDescription()).thenReturn((Object)"Description for the new tag");
        Mockito.when((Object)tag.getRestrictedGroups()).thenReturn(Arrays.asList("g1", "groupNew"));
        Tag tag2 = (Tag)Mockito.mock(Tag.class);
        Mockito.when((Object)tag2.getId()).thenReturn((Object)"products");
        Mockito.when((Object)tag2.getName()).thenReturn((Object)"Products");
        Mockito.when((Object)tag2.getDescription()).thenReturn((Object)"Description for products tag");
        Mockito.when((Object)tag2.getRestrictedGroups()).thenReturn(Arrays.asList("group1", "group2"));
        Tag tag2Updated = (Tag)Mockito.mock(Tag.class);
        Mockito.when((Object)tag2Updated.getName()).thenReturn((Object)"New product");
        Mockito.when((Object)tag2Updated.getDescription()).thenReturn((Object)"New description");
        Mockito.when((Object)tag2Updated.getRestrictedGroups()).thenReturn(Collections.singletonList("group"));
        Set tags = Sets.newSet((Object[])new Tag[]{tag, tag2, (Tag)Mockito.mock(Tag.class)});
        Set tagsAfterDelete = Sets.newSet((Object[])new Tag[]{tag, tag2});
        Set tagsAfterAdd = Sets.newSet((Object[])new Tag[]{tag, tag2, (Tag)Mockito.mock(Tag.class), (Tag)Mockito.mock(Tag.class)});
        Mockito.when((Object)tagRepository.findAll()).thenReturn((Object)tags, (Object[])new Set[]{tagsAfterAdd, tags, tagsAfterDelete, tags});
        Mockito.when((Object)tagRepository.create(Mockito.any(Tag.class))).thenReturn((Object)tag);
        Mockito.when((Object)tagRepository.findById((Object)"new-tag")).thenReturn(Optional.of(tag));
        Mockito.when((Object)tagRepository.findById((Object)"products")).thenReturn(Optional.of(tag2), (Object[])new Optional[]{Optional.of(tag2Updated)});
        Mockito.when((Object)tagRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

