/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.TenantRepository;
import io.gravitee.repository.management.model.Tenant;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class TenantRepositoryMock
extends AbstractRepositoryMock<TenantRepository> {
    public TenantRepositoryMock() {
        super(TenantRepository.class);
    }

    @Override
    void prepare(TenantRepository tenantRepository) throws Exception {
        Tenant tenant = (Tenant)Mockito.mock(Tenant.class);
        Mockito.when((Object)tenant.getName()).thenReturn((Object)"Tenant name");
        Mockito.when((Object)tenant.getDescription()).thenReturn((Object)"Description for the new tenant");
        Tenant tenant2 = (Tenant)Mockito.mock(Tenant.class);
        Mockito.when((Object)tenant2.getId()).thenReturn((Object)"tenant");
        Mockito.when((Object)tenant2.getName()).thenReturn((Object)"Asia");
        Tenant tenant2Updated = (Tenant)Mockito.mock(Tenant.class);
        Mockito.when((Object)tenant2Updated.getName()).thenReturn((Object)"New tenant");
        Mockito.when((Object)tenant2Updated.getDescription()).thenReturn((Object)"New description");
        Set tenants = Sets.newSet((Object[])new Tenant[]{tenant, tenant2, (Tenant)Mockito.mock(Tenant.class)});
        Set tenantsAfterDelete = Sets.newSet((Object[])new Tenant[]{tenant, tenant2});
        Set tenantsAfterAdd = Sets.newSet((Object[])new Tenant[]{tenant, tenant2, (Tenant)Mockito.mock(Tenant.class), (Tenant)Mockito.mock(Tenant.class)});
        Mockito.when((Object)tenantRepository.findAll()).thenReturn((Object)tenants, (Object[])new Set[]{tenantsAfterAdd, tenants, tenantsAfterDelete, tenants});
        Mockito.when((Object)tenantRepository.create(Mockito.any(Tenant.class))).thenReturn((Object)tenant);
        Mockito.when((Object)tenantRepository.findById((Object)"new-tenant")).thenReturn(Optional.of(tenant));
        Mockito.when((Object)tenantRepository.findById((Object)"asia")).thenReturn(Optional.of(tenant2), (Object[])new Optional[]{Optional.of(tenant2Updated)});
        Mockito.when((Object)tenantRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

