/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.model.Theme;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class ThemeRepositoryMock
extends AbstractRepositoryMock<ThemeRepository> {
    public ThemeRepositoryMock() {
        super(ThemeRepository.class);
    }

    @Override
    void prepare(ThemeRepository themeRepository) throws Exception {
        Theme theme = this.mockTheme("dark", "ENVIRONMENT", "DEFAULT", "Theme dark", true, "{\"def\": \"value\"}", new Date(1000000000000L), new Date(1111111111111L), "logo", "backgroundImage", "optionalLogo");
        Theme theme2 = this.mockTheme("light", "ENVIRONMENT", "DEFAULT", "Light", true, "{\"def\": \"value\"}", new Date(1000000000000L), new Date(1111111111111L), "logo", "backgroundImage", "optionalLogo");
        Theme theme2Updated = this.mockTheme("light", "PLATFORM", "TEST", "Awesome", true, "{\"def\": \"test\"}", new Date(1010101010101L), new Date(1030141710801L), "updateLogo", "updateBackground", null);
        Theme theme3 = this.mockTheme("simple", "ENVIRONMENT", "TEST", "Theme simple", false, "{\"def\": \"value\"}", new Date(1000002222222L), new Date(1111111111111L), "logo", "backgroundImage", "optionalLogo");
        Set themes = Sets.newSet((Object[])new Theme[]{theme, theme2, theme3});
        Set themesAfterDelete = Sets.newSet((Object[])new Theme[]{theme, theme2});
        Set themesAfterAdd = Sets.newSet((Object[])new Theme[]{theme, theme2, theme3, (Theme)Mockito.mock(Theme.class)});
        Mockito.when((Object)themeRepository.findAll()).thenReturn((Object)themes, (Object[])new Set[]{themesAfterAdd, themes, themesAfterDelete, themes});
        Mockito.when((Object)themeRepository.create(Mockito.any(Theme.class))).thenReturn((Object)theme);
        Mockito.when((Object)themeRepository.findById((Object)"new-theme")).thenReturn(Optional.of(theme));
        Mockito.when((Object)themeRepository.findById((Object)"light")).thenReturn(Optional.of(theme2), (Object[])new Optional[]{Optional.of(theme2Updated)});
        Mockito.when((Object)themeRepository.findByReferenceIdAndReferenceType("DEFAULT", "ENVIRONMENT")).thenReturn((Object)Sets.newSet((Object[])new Theme[]{theme, theme2}));
        Mockito.when((Object)themeRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }

    private Theme mockTheme(String id, String referenceType, String referenceId, String name, boolean isEnabled, String definition, Date createdAt, Date updatedAt, String logo, String backgroundImage, String optionalLogo) {
        Theme theme = (Theme)Mockito.mock(Theme.class);
        Mockito.when((Object)theme.getId()).thenReturn((Object)id);
        Mockito.when((Object)theme.getReferenceId()).thenReturn((Object)referenceId);
        Mockito.when((Object)theme.getReferenceType()).thenReturn((Object)referenceType);
        Mockito.when((Object)theme.getName()).thenReturn((Object)name);
        Mockito.when((Object)theme.isEnabled()).thenReturn((Object)isEnabled);
        Mockito.when((Object)theme.getDefinition()).thenReturn((Object)definition);
        Mockito.when((Object)theme.getCreatedAt()).thenReturn((Object)createdAt);
        Mockito.when((Object)theme.getUpdatedAt()).thenReturn((Object)updatedAt);
        Mockito.when((Object)theme.getLogo()).thenReturn((Object)logo);
        Mockito.when((Object)theme.getBackgroundImage()).thenReturn((Object)backgroundImage);
        Mockito.when((Object)theme.getOptionalLogo()).thenReturn((Object)optionalLogo);
        return theme;
    }
}

