/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.TokenRepository;
import io.gravitee.repository.management.model.Token;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class TokenRepositoryMock
extends AbstractRepositoryMock<TokenRepository> {
    public TokenRepositoryMock() {
        super(TokenRepository.class);
    }

    @Override
    void prepare(TokenRepository tokenRepository) throws Exception {
        Token token = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)token.getId()).thenReturn((Object)"token123");
        Mockito.when((Object)token.getToken()).thenReturn((Object)"token1");
        Mockito.when((Object)token.getName()).thenReturn((Object)"My personal token");
        Mockito.when((Object)token.getReferenceType()).thenReturn((Object)"USER");
        Mockito.when((Object)token.getReferenceId()).thenReturn((Object)"123");
        Mockito.when((Object)token.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)token.getExpiresAt()).thenReturn((Object)new Date(1486772200000L));
        Mockito.when((Object)token.getLastUseAt()).thenReturn((Object)new Date(1486773200000L));
        Token token2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)token2.getId()).thenReturn((Object)"token_to_delete");
        Mockito.when((Object)token2.getToken()).thenReturn((Object)"token2");
        Mockito.when((Object)token2.getName()).thenReturn((Object)"My token");
        Mockito.when((Object)token2.getReferenceType()).thenReturn((Object)"USER");
        Mockito.when((Object)token2.getReferenceId()).thenReturn((Object)"123");
        Mockito.when((Object)token2.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Token createdToken = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)createdToken.getId()).thenReturn((Object)"new-token");
        Mockito.when((Object)createdToken.getToken()).thenReturn((Object)"token0");
        Mockito.when((Object)createdToken.getName()).thenReturn((Object)"Token name");
        Mockito.when((Object)createdToken.getReferenceType()).thenReturn((Object)"USER");
        Mockito.when((Object)createdToken.getReferenceId()).thenReturn((Object)"456");
        Mockito.when((Object)createdToken.getCreatedAt()).thenReturn((Object)new Date(1486771200000L));
        Mockito.when((Object)createdToken.getExpiresAt()).thenReturn((Object)new Date(1486772200000L));
        Mockito.when((Object)createdToken.getLastUseAt()).thenReturn((Object)new Date(1486773200000L));
        Token updatedToken = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)updatedToken.getId()).thenReturn((Object)"token123");
        Mockito.when((Object)updatedToken.getToken()).thenReturn((Object)"new_token");
        Mockito.when((Object)updatedToken.getName()).thenReturn((Object)"New token name");
        Mockito.when((Object)updatedToken.getReferenceType()).thenReturn((Object)"New ref type");
        Mockito.when((Object)updatedToken.getReferenceId()).thenReturn((Object)"New ref id");
        Mockito.when((Object)updatedToken.getCreatedAt()).thenReturn((Object)new Date(1486774200000L));
        Mockito.when((Object)updatedToken.getExpiresAt()).thenReturn((Object)new Date(1486775200000L));
        Mockito.when((Object)updatedToken.getLastUseAt()).thenReturn((Object)new Date(1486776200000L));
        List<Token> tokens = Arrays.asList(token, token2);
        List<Token> tokensAfterDelete = Collections.singletonList(token);
        Mockito.when((Object)tokenRepository.findAll()).thenReturn((Object)Sets.newSet((Object[])new Token[]{token, token2, (Token)Mockito.mock(Token.class), (Token)Mockito.mock(Token.class)}));
        Mockito.when((Object)tokenRepository.findByReference("USER", "123")).thenReturn(tokens, (Object[])new List[]{tokensAfterDelete, tokens});
        Mockito.when((Object)tokenRepository.findByReference("USER", "456")).thenReturn(Collections.emptyList(), (Object[])new List[]{Collections.singletonList(createdToken)});
        Mockito.when((Object)tokenRepository.findByReference("USER", "token_to_delete")).thenReturn(Collections.singletonList(Mockito.mock(Token.class)), (Object[])new List[]{Collections.emptyList()});
        Mockito.when((Object)tokenRepository.create(Mockito.any(Token.class))).thenReturn((Object)createdToken);
        Mockito.when((Object)tokenRepository.findById((Object)"new-token")).thenReturn(Optional.of(createdToken));
        Mockito.when((Object)tokenRepository.findById((Object)"token123")).thenReturn(Optional.of(token), (Object[])new Optional[]{Optional.of(updatedToken)});
        Mockito.when((Object)tokenRepository.update(Matchers.argThat(o -> o == null || o.getToken().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
    }
}

