/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.User;
import io.gravitee.repository.management.model.UserStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class UserRepositoryMock
extends AbstractRepositoryMock<UserRepository> {
    public UserRepositoryMock() {
        super(UserRepository.class);
    }

    @Override
    void prepare(UserRepository userRepository) throws Exception {
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getId()).thenReturn((Object)"createuser1");
        Mockito.when((Object)user.getOrganizationId()).thenReturn((Object)"DEFAULT");
        Mockito.when((Object)user.getPassword()).thenReturn((Object)"New pwd");
        Mockito.when((Object)user.getEmail()).thenReturn((Object)"createuser1@gravitee.io");
        Mockito.when((Object)user.getLoginCount()).thenReturn((Object)123L);
        Mockito.when((Object)user.getFirstConnectionAt()).thenReturn((Object)new Date(1439052010883L));
        Mockito.when((Object)user.getNewsletterSubscribed()).thenReturn(null);
        User userUpdated = (User)Mockito.mock(User.class);
        Mockito.when((Object)userUpdated.getId()).thenReturn((Object)"id2update");
        Mockito.when((Object)userUpdated.getOrganizationId()).thenReturn((Object)"new_DEFAULT");
        Mockito.when((Object)userUpdated.getSource()).thenReturn((Object)"sourceUpdated");
        Mockito.when((Object)userUpdated.getSourceId()).thenReturn((Object)"sourceIdUpdated");
        Mockito.when((Object)userUpdated.getPassword()).thenReturn((Object)"passwordUpdated");
        Mockito.when((Object)userUpdated.getEmail()).thenReturn((Object)"emailUpdated");
        Mockito.when((Object)userUpdated.getFirstname()).thenReturn((Object)"firstnameUpdated");
        Mockito.when((Object)userUpdated.getLastname()).thenReturn((Object)"lastnameUpdated");
        Mockito.when((Object)userUpdated.getPicture()).thenReturn((Object)"pictureUpdated");
        Mockito.when((Object)userUpdated.getCreatedAt()).thenReturn((Object)new Date(1439032010883L));
        Mockito.when((Object)userUpdated.getUpdatedAt()).thenReturn((Object)new Date(1439042010883L));
        Mockito.when((Object)userUpdated.getLastConnectionAt()).thenReturn((Object)new Date(1439052010883L));
        Mockito.when((Object)userUpdated.getStatus()).thenReturn((Object)UserStatus.ARCHIVED);
        Mockito.when((Object)userUpdated.getLoginCount()).thenReturn((Object)123L);
        Mockito.when((Object)userUpdated.getFirstConnectionAt()).thenReturn((Object)new Date(1439052010883L));
        Mockito.when((Object)userUpdated.getNewsletterSubscribed()).thenReturn((Object)true);
        User user0 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user0.getId()).thenReturn((Object)"user0");
        User user1 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user1.getId()).thenReturn((Object)"user1");
        User user2 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user2.getId()).thenReturn((Object)"user2");
        User user3 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user3.getId()).thenReturn((Object)"user3");
        User user4 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user4.getId()).thenReturn((Object)"user4");
        User user5 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user5.getId()).thenReturn((Object)"user5");
        User id2update = (User)Mockito.mock(User.class);
        Mockito.when((Object)id2update.getId()).thenReturn((Object)"id2update");
        User user2delete = (User)Mockito.mock(User.class);
        Mockito.when((Object)user2delete.getId()).thenReturn((Object)"user2delete");
        User userSpecialChar = (User)Mockito.mock(User.class);
        Mockito.when((Object)userSpecialChar.getId()).thenReturn((Object)"idSpecialChar");
        Page searchAllResult = new Page(Arrays.asList(user0, user1, user3, user5, user2, user4, id2update, userSpecialChar, user2delete), 0, 0, 8L);
        Mockito.when((Object)userRepository.search((UserCriteria)Mockito.isNull(UserCriteria.class), (Pageable)Mockito.any())).thenReturn((Object)searchAllResult);
        Mockito.when((Object)userRepository.search((UserCriteria)Matchers.argThat(o -> o != null && (o.getStatuses() == null || o.getStatuses().length == 0)), (Pageable)Mockito.any())).thenReturn((Object)searchAllResult);
        Mockito.when((Object)userRepository.search((UserCriteria)Matchers.argThat(o -> o != null && o.getStatuses() != null && o.getStatuses().length == 1 && UserStatus.ARCHIVED.equals((Object)o.getStatuses()[0])), (Pageable)Mockito.any())).thenReturn((Object)new Page(Collections.singletonList(Mockito.mock(User.class)), 0, 0, 1L));
        Mockito.when((Object)userRepository.search((UserCriteria)Matchers.argThat(o -> o != null && o.getStatuses() != null && o.getStatuses().length == 1 && UserStatus.ACTIVE.equals((Object)o.getStatuses()[0])), (Pageable)Mockito.any())).thenReturn((Object)new Page(Arrays.asList(user, (User)Mockito.mock(User.class), (User)Mockito.mock(User.class), (User)Mockito.mock(User.class), (User)Mockito.mock(User.class), (User)Mockito.mock(User.class), (User)Mockito.mock(User.class)), 0, 0, 6L));
        Mockito.when((Object)userRepository.search((UserCriteria)Matchers.argThat(o -> o != null && o.getStatuses() == null && o.hasNoStatus()), (Pageable)Mockito.any())).thenReturn((Object)new Page(Arrays.asList((User)Mockito.mock(User.class)), 0, 0, 1L));
        Mockito.when((Object)userRepository.search((UserCriteria)Matchers.argThat(o -> o != null && "DEFAULT".equals(o.getOrganizationId())), (Pageable)Mockito.any())).thenReturn((Object)new Page(Arrays.asList(user0), 0, 0, 1L));
        Mockito.when((Object)userRepository.create(Mockito.any(User.class))).thenReturn((Object)user);
        Mockito.when((Object)userRepository.findById((Object)"user0")).thenReturn(Optional.of(user));
        Mockito.when((Object)userRepository.findById((Object)"id2update")).thenReturn(Optional.of(userUpdated));
        Mockito.when((Object)user.getId()).thenReturn((Object)"createuser1");
        Mockito.when((Object)user.getEmail()).thenReturn((Object)"createuser1@gravitee.io");
        Mockito.when((Object)user.getStatus()).thenReturn((Object)UserStatus.ACTIVE);
        Mockito.when((Object)userRepository.findBySource("gravitee", "createuser1", "DEFAULT")).thenReturn(Optional.of(user));
        Mockito.when((Object)userRepository.update(Matchers.argThat(o -> o != null && "id2update".equals(o.getId())))).thenReturn((Object)userUpdated);
        Mockito.when((Object)userRepository.update(Matchers.argThat(o -> o == null || "unknown".equals(o.getId())))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)userRepository.findByEmail("user0@gravitee.io", "DEFAULT")).thenReturn(Optional.of(user0));
        Mockito.when((Object)userRepository.findByEmail("usER0@gravitee.io", "DEFAULT")).thenReturn(Optional.of(user0));
        Mockito.when((Object)userRepository.findBySource("gravitee", "user1", "DEV")).thenReturn(Optional.of(user1));
        Mockito.when((Object)userRepository.findBySource("gravitee", "USER1", "DEV")).thenReturn(Optional.of(user1));
        Mockito.when((Object)userRepository.findBySource("gravitee", "user", "DEV")).thenReturn(Optional.empty());
        Mockito.when((Object)userRepository.findBySource("sourceSpecialChar", "sourceIdSpecialChar+test@me", "DEV")).thenReturn(Optional.of(userSpecialChar));
        Mockito.when((Object)userRepository.findById((Object)"user1")).thenReturn(Optional.of(user1));
        Mockito.when((Object)userRepository.findByIds(Arrays.asList("user1", "user5"))).thenReturn(new HashSet<User>(Arrays.asList(user1, user5)));
        Mockito.when((Object)userRepository.findById((Object)"user2delete")).thenReturn(Optional.of(new User()), (Object[])new Optional[]{Optional.empty()});
    }
}

