/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.config.mock;

import io.gravitee.repository.config.mock.AbstractRepositoryMock;
import io.gravitee.repository.management.api.WorkflowRepository;
import io.gravitee.repository.management.model.Workflow;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;

public class WorkflowRepositoryMock
extends AbstractRepositoryMock<WorkflowRepository> {
    public WorkflowRepositoryMock() {
        super(WorkflowRepository.class);
    }

    @Override
    void prepare(WorkflowRepository workflowRepository) throws Exception {
        Date date = new Date(1439022010883L);
        Workflow workflow = new Workflow();
        workflow.setId("new-workflow");
        workflow.setReferenceType("API");
        workflow.setReferenceId("api-id");
        workflow.setType("REVIEW");
        workflow.setState("DRAFT");
        workflow.setComment("test");
        workflow.setCreatedAt(date);
        Workflow workflow2 = new Workflow();
        workflow2.setId("workflow");
        Workflow workflowBeforUpdate = new Workflow();
        workflowBeforUpdate.setId("workflow");
        workflowBeforUpdate.setState("IN_REVIEW");
        Workflow workflow2Updated = new Workflow();
        workflow2Updated.setId("workflow");
        workflow2Updated.setReferenceType("New reference type");
        workflow2Updated.setReferenceId("New reference id");
        workflow2Updated.setType("New type");
        workflow2Updated.setState("IN_REVIEW");
        workflow2Updated.setComment("New comment");
        workflow2Updated.setCreatedAt(date);
        Workflow oldWorkflow = new Workflow();
        oldWorkflow.setId("old-workflow");
        oldWorkflow.setReferenceType("API");
        oldWorkflow.setReferenceId("api-id");
        oldWorkflow.setType("REVIEW");
        oldWorkflow.setState("DRAFT");
        oldWorkflow.setComment("Comment");
        oldWorkflow.setUser("User");
        oldWorkflow.setCreatedAt(new Date(1518357357000L));
        Workflow workflow3 = new Workflow();
        workflow3.setId("workflow-api");
        Set workflows = Sets.newSet((Object[])new Workflow[]{workflow, oldWorkflow, workflow2Updated, workflow3});
        Set workflowsAfterDelete = Sets.newSet((Object[])new Workflow[]{workflow, oldWorkflow, workflow3});
        Set workflowsAfterAdd = Sets.newSet((Object[])new Workflow[]{workflow, workflow2, workflow3, (Workflow)Mockito.mock(Workflow.class), (Workflow)Mockito.mock(Workflow.class)});
        Mockito.when((Object)workflowRepository.findAll()).thenReturn((Object)workflows, (Object[])new Set[]{workflowsAfterAdd, workflows, workflowsAfterDelete, workflows});
        Mockito.when((Object)workflowRepository.create(Matchers.any(Workflow.class))).thenReturn((Object)workflow);
        Mockito.when((Object)workflowRepository.findById((Object)"new-workflow")).thenReturn(Optional.of(workflow));
        Mockito.when((Object)workflowRepository.findById((Object)"workflow")).thenReturn(Optional.of(workflowBeforUpdate), (Object[])new Optional[]{Optional.of(workflow2Updated)});
        Mockito.when((Object)workflowRepository.update(Matchers.argThat(o -> o == null || o.getId().equals("unknown")))).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)workflowRepository.findByReferenceAndType("API", "api-id", "REVIEW")).thenReturn(Arrays.asList(workflow2, oldWorkflow, workflow3));
    }
}

