/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static Date parse(String stringDate) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat.parse(stringDate);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static boolean compareDate(String expectedDateToParse, Date actualDate) {
        return DateUtils.compareDate(DateUtils.parse(expectedDateToParse), actualDate);
    }

    public static boolean compareDate(Date expectedDate, Date actualDate) {
        if (actualDate == null) {
            return expectedDate == null;
        }
        if (expectedDate == null) {
            return false;
        }
        return DateUtils.compareDate(expectedDate.getTime(), actualDate.getTime());
    }

    public static boolean compareDate(long expectedTimestamp, long actualTimestamp) {
        return Math.abs(expectedTimestamp - actualTimestamp) < 3L;
    }
}

