/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.EventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class EventCriteria {
    private Collection<EventType> types;
    private Map<String, Object> properties;
    private long from;
    private long to;
    private String environmentId;

    EventCriteria(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.types = new HashSet<EventType>(builder.types);
        this.properties = new HashMap<String, Object>(builder.properties);
        this.environmentId = builder.environmentId;
    }

    public Collection<EventType> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<EventType> types) {
        this.types = types;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCriteria that = (EventCriteria)o;
        if (this.from != that.from) {
            return false;
        }
        if (this.to != that.to) {
            return false;
        }
        if (this.types != null ? !this.types.equals(that.types) : that.types != null) {
            return false;
        }
        if (this.environmentId != null ? !this.environmentId.equals(that.environmentId) : that.environmentId != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result = this.types != null ? this.types.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.environmentId != null ? this.environmentId.hashCode() : 0);
        result = 31 * result + (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        return result;
    }

    public static class Builder {
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Collection<EventType> types = new ArrayList<EventType>();
        private long from;
        private long to;
        private String environmentId;

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder types(EventType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.types.add(types[i]);
            }
            return this;
        }

        public Builder property(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public EventCriteria build() {
            return new EventCriteria(this);
        }
    }
}

