/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search.builder;

import io.gravitee.repository.management.api.search.Pageable;

class PageableImpl
implements Pageable {
    private int pageSize;
    private int pageNumber;

    public PageableImpl(int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public int pageNumber() {
        return this.pageNumber;
    }

    @Override
    public int from() {
        return this.pageNumber * this.pageSize;
    }

    @Override
    public int to() {
        return (this.pageNumber + 1) * this.pageSize - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageableImpl pageable = (PageableImpl)o;
        if (this.pageSize != pageable.pageSize) {
            return false;
        }
        return this.pageNumber == pageable.pageNumber;
    }

    public int hashCode() {
        int result = this.pageSize;
        result = 31 * result + this.pageNumber;
        return result;
    }
}

