/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.tracer.jaeger;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.tracing.vertx.VertxTracer;
import io.gravitee.tracer.jaeger.HeadersPropagatorGetter;
import io.gravitee.tracer.jaeger.HeadersPropagatorSetter;
import io.gravitee.tracer.jaeger.JaegerSpan;
import io.gravitee.tracer.jaeger.VertxContextStorageProvider;
import io.gravitee.tracer.jaeger.configuration.JaegerTracerConfiguration;
import io.gravitee.tracing.api.Span;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.SslContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLEngine;
import org.springframework.beans.factory.annotation.Autowired;

public class JaegerTracer
extends AbstractService<io.gravitee.node.api.tracing.Tracer>
implements VertxTracer<io.opentelemetry.api.trace.Span, io.opentelemetry.api.trace.Span> {
    private static final String KEYSTORE_FORMAT_JKS = "JKS";
    private static final String KEYSTORE_FORMAT_PEM = "PEM";
    private static final String KEYSTORE_FORMAT_PKCS12 = "PKCS12";
    private static final TextMapGetter<Iterable<Map.Entry<String, String>>> getter = new HeadersPropagatorGetter();
    private static final TextMapSetter<BiConsumer<String, String>> setter = new HeadersPropagatorSetter();
    private Tracer tracer;
    private ContextPropagators propagators;
    @Autowired
    private JaegerTracerConfiguration configuration;
    @Autowired
    private Node node;
    @Autowired
    private Vertx vertx;

    protected void doStart() {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)this.configuration.getHost(), (int)this.configuration.getPort());
        HttpClientOptions sslOptions = this.getHttpClientSSLOptionsFromConfiguration();
        if (sslOptions != null) {
            final SSLHelper helper = new SSLHelper(sslOptions, sslOptions.getKeyCertOptions(), sslOptions.getTrustOptions());
            helper.setApplicationProtocols(Collections.singletonList(HttpVersion.HTTP_2.alpnName()));
            SslContext ctx = helper.getContext((VertxInternal)this.vertx);
            channelBuilder.sslContext((SslContext)new DelegatingSslContext(ctx){

                protected void initEngine(SSLEngine engine) {
                    helper.configureEngine(engine, null);
                }
            }).useTransportSecurity().build();
        } else {
            channelBuilder.usePlaintext();
        }
        ManagedChannel channel = channelBuilder.build();
        JaegerGrpcSpanExporter exporter = JaegerGrpcSpanExporter.builder().setChannel(channel).setTimeout(30L, TimeUnit.SECONDS).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)this.node.application()));
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)exporter).build()).setResource(Resource.getDefault().merge(serviceNameResource)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
        this.tracer = openTelemetry.getTracer("io.gravitee");
        this.propagators = openTelemetry.getPropagators();
    }

    private HttpClientOptions getHttpClientSSLOptionsFromConfiguration() {
        if (!this.configuration.isSslEnabled()) {
            return null;
        }
        HttpClientOptions options = new HttpClientOptions().setSsl(true).setVerifyHost(this.configuration.isHostnameVerifier()).setTrustAll(this.configuration.isTrustAll());
        if (this.configuration.getKeystoreType() != null) {
            if (this.configuration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_JKS)) {
                options.setKeyStoreOptions(new JksOptions().setPath(this.configuration.getKeystorePath()).setPassword(this.configuration.getKeystorePassword()));
            } else if (this.configuration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PKCS12)) {
                options.setPfxKeyCertOptions(new PfxOptions().setPath(this.configuration.getKeystorePath()).setPassword(this.configuration.getKeystorePassword()));
            } else if (this.configuration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PEM)) {
                options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPaths(this.configuration.getKeystorePemCerts()).setKeyPaths(this.configuration.getKeystorePemKeys()));
            }
        }
        if (this.configuration.getTruststoreType() != null) {
            if (this.configuration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_JKS)) {
                options.setTrustStoreOptions(new JksOptions().setPath(this.configuration.getTruststorePath()).setPassword(this.configuration.getTruststorePassword()));
            } else if (this.configuration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PKCS12)) {
                options.setPfxTrustOptions(new PfxOptions().setPath(this.configuration.getTruststorePath()).setPassword(this.configuration.getTruststorePassword()));
            } else if (this.configuration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PEM)) {
                options.setPemTrustOptions(new PemTrustOptions().addCertPath(this.configuration.getTruststorePath()));
            }
        }
        return options;
    }

    public <R> io.opentelemetry.api.trace.Span receiveRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy)) {
            return null;
        }
        Context tracingContext = this.propagators.getTextMapPropagator().extract(Context.root(), headers, getter);
        if (io.opentelemetry.api.trace.Span.fromContextOrNull((Context)tracingContext) == null && TracingPolicy.PROPAGATE.equals((Object)policy)) {
            return null;
        }
        io.opentelemetry.api.trace.Span span = this.reportTagsAndStart(this.tracer.spanBuilder(operation).setParent(tracingContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.CLIENT : SpanKind.PRODUCER), request, tagExtractor);
        VertxContextStorageProvider.VertxContextStorage.INSTANCE.attach(context, tracingContext.with((ImplicitContextKeyed)span));
        return span;
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, io.opentelemetry.api.trace.Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            VertxContextStorageProvider.VertxContextStorage.INSTANCE.clear(context);
            this.end(span, response, tagExtractor, failure);
        }
    }

    private <R> void end(io.opentelemetry.api.trace.Span span, R response, TagExtractor<R> tagExtractor, Throwable failure) {
        if (failure != null) {
            span.recordException(failure);
        }
        if (response != null) {
            tagExtractor.extractTo(response, (arg_0, arg_1) -> ((io.opentelemetry.api.trace.Span)span).setAttribute(arg_0, arg_1));
        }
        span.end();
    }

    public <R> io.opentelemetry.api.trace.Span sendRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (TracingPolicy.IGNORE.equals((Object)policy) || request == null) {
            return null;
        }
        Context tracingContext = VertxContextStorageProvider.VertxContextStorage.INSTANCE.current(context);
        if (tracingContext == null && !TracingPolicy.ALWAYS.equals((Object)policy)) {
            return null;
        }
        if (tracingContext == null) {
            tracingContext = Context.root();
        }
        io.opentelemetry.api.trace.Span span = this.reportTagsAndStart(this.tracer.spanBuilder(operation).setParent(tracingContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.CLIENT : SpanKind.PRODUCER), request, tagExtractor);
        tracingContext = tracingContext.with((ImplicitContextKeyed)span);
        this.propagators.getTextMapPropagator().inject(tracingContext, headers, setter);
        return span;
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, io.opentelemetry.api.trace.Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span != null) {
            this.end(span, response, tagExtractor, failure);
        }
    }

    private <T> io.opentelemetry.api.trace.Span reportTagsAndStart(SpanBuilder span, T obj, TagExtractor<T> tagExtractor) {
        int len = tagExtractor.len(obj);
        for (int idx = 0; idx < len; ++idx) {
            span.setAttribute(tagExtractor.name(obj, idx), tagExtractor.value(obj, idx));
        }
        return span.startSpan();
    }

    protected void doStop() {
        this.close();
    }

    public Span trace(String spanName) {
        Context tracingContext = VertxContextStorageProvider.VertxContextStorage.INSTANCE.current();
        if (tracingContext == null) {
            tracingContext = Context.root();
        }
        io.opentelemetry.api.trace.Span span = this.tracer.spanBuilder(spanName).setParent(tracingContext).startSpan();
        Scope scope = VertxContextStorageProvider.VertxContextStorage.INSTANCE.attach(tracingContext.with((ImplicitContextKeyed)span));
        return new JaegerSpan(span, scope);
    }
}

