/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.tracer.jaeger.configuration;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;

public class JaegerTracerConfiguration {
    @Value(value="${services.tracing.jaeger.ssl.enabled:false}")
    private boolean sslEnabled;
    @Value(value="${services.tracing.jaeger.ssl.keystore.type:#{null}}")
    private String keystoreType;
    @Value(value="${services.tracing.jaeger.ssl.keystore.path:#{null}}")
    private String keystorePath;
    @Value(value="${services.tracing.jaeger.ssl.keystore.password:#{null}}")
    private String keystorePassword;
    private List<String> keystorePemCerts;
    private List<String> keystorePemKeys;
    @Value(value="${services.tracing.jaeger.ssl.trustall:false}")
    private boolean trustAll;
    @Value(value="${services.tracing.jaeger.ssl.verifyHostname:true}")
    private boolean hostnameVerifier;
    @Value(value="${services.tracing.jaeger.ssl.truststore.type:#{null}}")
    private String truststoreType;
    @Value(value="${services.tracing.jaeger.ssl.truststore.path:#{null}}")
    private String truststorePath;
    @Value(value="${services.tracing.jaeger.ssl.truststore.password:#{null}}")
    private String truststorePassword;
    @Value(value="${services.tracing.jaeger.host:localhost}")
    private String host;
    @Value(value="${services.tracing.jaeger.port:14250}")
    private int port;
    @Autowired
    private Environment environment;

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public List<String> getKeystorePemCerts() {
        if (this.keystorePemCerts == null) {
            this.keystorePemCerts = this.initializeKeystorePemCerts("services.tracing.jaeger.ssl.keystore.certs[%s]");
        }
        return this.keystorePemCerts;
    }

    private List<String> initializeKeystorePemCerts(String property) {
        String key = String.format(property, 0);
        ArrayList<String> values = new ArrayList<String>();
        while (this.environment.containsProperty(key)) {
            values.add(this.environment.getProperty(key));
            key = String.format(property, values.size());
        }
        return values;
    }

    public void setKeystorePemCerts(List<String> keystorePemCerts) {
        this.keystorePemCerts = keystorePemCerts;
    }

    public List<String> getKeystorePemKeys() {
        if (this.keystorePemKeys == null) {
            this.keystorePemKeys = this.initializeKeystorePemCerts("services.tracing.jaeger.ssl.keystore.keys[%s]");
        }
        return this.keystorePemKeys;
    }

    public void setKeystorePemKeys(List<String> keystorePemKeys) {
        this.keystorePemKeys = keystorePemKeys;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean isHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(boolean hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

