/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import io.greptime.common.util.NamedThreadFactory;
import io.greptime.common.util.StringBuilderHelper;
import io.greptime.common.util.ThreadPoolUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUtil.class);
    private static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();
    private static final ScheduledReporter SCHEDULED_REPORTER;

    private static ScheduledReporter createReporter(ScheduledExecutorService scheduledPool) {
        try {
            return Slf4jReporter.forRegistry((MetricRegistry)METRIC_REGISTRY).withLoggingLevel(Slf4jReporter.LoggingLevel.INFO).outputTo(LOG).scheduleOn(scheduledPool).shutdownExecutorOnStop(true).build();
        }
        catch (Throwable ex) {
            LOG.warn("Fail to create metrics reporter.", ex);
            return null;
        }
    }

    public static void startScheduledReporter(long period, TimeUnit unit) {
        if (SCHEDULED_REPORTER != null) {
            LOG.info("Starting the metrics scheduled reporter.");
            SCHEDULED_REPORTER.start(period, unit);
        }
    }

    public static void stopScheduledReporterAndDestroy() {
        if (SCHEDULED_REPORTER != null) {
            LOG.info("Stopping the metrics scheduled reporter.");
            SCHEDULED_REPORTER.stop();
        }
    }

    public static void reportImmediately() {
        SCHEDULED_REPORTER.report();
    }

    public static MetricRegistry metricRegistry() {
        return METRIC_REGISTRY;
    }

    public static Meter meter(Object name) {
        return METRIC_REGISTRY.meter(MetricsUtil.named(name));
    }

    public static Meter meter(Object ... names) {
        return METRIC_REGISTRY.meter(MetricsUtil.named(names));
    }

    public static Timer timer(Object name) {
        return METRIC_REGISTRY.timer(MetricsUtil.named(name));
    }

    public static Timer timer(Object ... names) {
        return METRIC_REGISTRY.timer(MetricsUtil.named(names));
    }

    public static Counter counter(Object name) {
        return METRIC_REGISTRY.counter(MetricsUtil.named(name));
    }

    public static Counter counter(Object ... names) {
        return METRIC_REGISTRY.counter(MetricsUtil.named(names));
    }

    public static Histogram histogram(Object name) {
        return METRIC_REGISTRY.histogram(MetricsUtil.named(name));
    }

    public static Histogram histogram(Object ... names) {
        return METRIC_REGISTRY.histogram(MetricsUtil.named(names));
    }

    public static String named(Object name) {
        return String.valueOf(name);
    }

    public static String namedById(String id, String ... names) {
        StringBuilder buf = StringBuilderHelper.get();
        buf.append(id);
        MetricsUtil.named0(buf, names);
        return buf.toString();
    }

    public static String named(Object ... names) {
        StringBuilder buf = StringBuilderHelper.get();
        MetricsUtil.named0(buf, names);
        return buf.toString();
    }

    private static void named0(StringBuilder buf, Object ... names) {
        for (Object name : names) {
            if (buf.length() > 0) {
                buf.append('_');
            }
            buf.append(name);
        }
    }

    private static void named0(StringBuilder buf, String ... names) {
        for (String name : names) {
            if (buf.length() > 0) {
                buf.append('_');
            }
            buf.append(name);
        }
    }

    private MetricsUtil() {
    }

    static {
        ScheduledThreadPoolExecutor scheduledPool = ThreadPoolUtil.newScheduledBuilder().enableMetric(true).coreThreads(1).poolName("metrics.reporter").threadFactory(new NamedThreadFactory("metrics.reporter", true)).build();
        SCHEDULED_REPORTER = MetricsUtil.createReporter(scheduledPool);
    }
}

