/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import java.util.ArrayList;

public final class Strings {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String emptyToNull(String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !Strings.isBlank(str);
    }

    public static String[] split(String str, char separator) {
        return Strings.split(str, separator, false);
    }

    public static String[] split(String str, char separator, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separator) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match || preserveAllTokens) {
            list.add(str.substring(start, i));
        }
        String[] arr = new String[list.size()];
        return list.toArray(arr);
    }

    private Strings() {
    }
}

