/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import io.greptime.CachedPojoObjectMapper;
import io.greptime.PojoObjectMapper;
import io.greptime.RouterClient;
import io.greptime.RpcServiceRegister;
import io.greptime.StreamWriter;
import io.greptime.Util;
import io.greptime.Write;
import io.greptime.WriteClient;
import io.greptime.WriteObject;
import io.greptime.WriteOp;
import io.greptime.common.Display;
import io.greptime.common.Endpoint;
import io.greptime.common.Lifecycle;
import io.greptime.common.signal.SignalHandlersLoader;
import io.greptime.common.util.MetricsUtil;
import io.greptime.common.util.ServiceLoader;
import io.greptime.common.util.Strings;
import io.greptime.models.Err;
import io.greptime.models.Result;
import io.greptime.models.Table;
import io.greptime.models.WriteOk;
import io.greptime.options.GreptimeOptions;
import io.greptime.options.RouterOptions;
import io.greptime.options.WriteOptions;
import io.greptime.rpc.Context;
import io.greptime.rpc.RpcClient;
import io.greptime.rpc.RpcFactoryProvider;
import io.greptime.rpc.RpcOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreptimeDB
implements Write,
WriteObject,
Lifecycle<GreptimeOptions>,
Display {
    private static final Logger LOG = LoggerFactory.getLogger(GreptimeDB.class);
    private static final Map<Integer, GreptimeDB> INSTANCES = new ConcurrentHashMap<Integer, GreptimeDB>();
    private static final AtomicInteger ID = new AtomicInteger(0);
    private static final String VERSION = Util.clientVersion();
    private static final String NODE_ID = UUID.randomUUID().toString();
    private static final PojoObjectMapper POJO_OBJECT_MAPPER = GreptimeDB.getDefaultPojoObjectMapper();
    private final int id;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private GreptimeOptions opts;
    private RouterClient routerClient;
    private WriteClient writeClient;

    public static List<GreptimeDB> instances() {
        return new ArrayList<GreptimeDB>(INSTANCES.values());
    }

    public static GreptimeDB create(GreptimeOptions opts) {
        GreptimeDB greptimeDB = new GreptimeDB();
        if (!greptimeDB.init(opts)) {
            throw new RuntimeException("Failed to start the GreptimeDB client");
        }
        LOG.info("GreptimeDB client started: {}", (Object)greptimeDB);
        return greptimeDB;
    }

    private GreptimeDB() {
        this.id = ID.incrementAndGet();
    }

    public boolean init(GreptimeOptions opts) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("GreptimeDB client has started");
        }
        this.opts = GreptimeOptions.checkSelf(opts).copy();
        if (Strings.isBlank((String)this.opts.getDatabase())) {
            LOG.warn("The `database` is not specified, use default (catalog-database): greptime-public");
        }
        this.routerClient = GreptimeDB.makeRouteClient(opts);
        this.writeClient = GreptimeDB.makeWriteClient(opts, this.routerClient);
        INSTANCES.put(this.id, this);
        Util.scheduleDisplaySelf(this, new LogPrinter(LOG));
        return true;
    }

    public void shutdownGracefully() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        if (this.writeClient != null) {
            this.writeClient.shutdownGracefully();
        }
        if (this.routerClient != null) {
            this.routerClient.shutdownGracefully();
        }
        INSTANCES.remove(this.id);
    }

    public void ensureInitialized() {
        if (this.started.get() && INSTANCES.containsKey(this.id)) {
            return;
        }
        throw new IllegalStateException(String.format("Client(%d) is not started", this.id));
    }

    @Override
    public CompletableFuture<Result<WriteOk, Err>> writeObjects(Collection<List<?>> objects, WriteOp writeOp, Context ctx) {
        ArrayList<Table> rows = new ArrayList<Table>(objects.size());
        for (List<?> pojo : objects) {
            rows.add(POJO_OBJECT_MAPPER.mapToTable(pojo));
        }
        return this.write(rows, writeOp, ctx);
    }

    @Override
    public StreamWriter<List<?>, WriteOk> objectsStreamWriter(int maxPointsPerSecond, Context ctx) {
        final StreamWriter<Table, WriteOk> delegate = this.streamWriter(maxPointsPerSecond, ctx);
        return new StreamWriter<List<?>, WriteOk>(){

            @Override
            public StreamWriter<List<?>, WriteOk> write(List<?> val, WriteOp writeOp) {
                Table table = POJO_OBJECT_MAPPER.mapToTable(val);
                delegate.write(table, writeOp);
                return this;
            }

            @Override
            public CompletableFuture<WriteOk> completed() {
                return delegate.completed();
            }
        };
    }

    @Override
    public CompletableFuture<Result<WriteOk, Err>> write(Collection<Table> tables, WriteOp writeOp, Context ctx) {
        this.ensureInitialized();
        return this.writeClient.write(tables, writeOp, this.attachCtx(ctx));
    }

    @Override
    public StreamWriter<Table, WriteOk> streamWriter(int maxPointsPerSecond, Context ctx) {
        return this.writeClient.streamWriter(maxPointsPerSecond, this.attachCtx(ctx));
    }

    public void display(Display.Printer out) {
        out.println((Object)"--- GreptimeDB Client ---").print((Object)"id=").println((Object)this.id).print((Object)"version=").println((Object)VERSION).print((Object)"endpoints=").println(this.opts.getEndpoints()).print((Object)"database=").println((Object)this.opts.getDatabase()).print((Object)"rpcOptions=").println((Object)this.opts.getRpcOptions());
        if (this.routerClient != null) {
            out.println((Object)"");
            this.routerClient.display(out);
        }
        if (this.writeClient != null) {
            out.println((Object)"");
            this.writeClient.display(out);
        }
        out.println((Object)"");
    }

    public String toString() {
        return "GreptimeDB{id=" + this.id + "version=" + VERSION + ", opts=" + this.opts + ", routerClient=" + this.routerClient + ", writeClient=" + this.writeClient + '}';
    }

    private Context attachCtx(Context ctx) {
        Context newCtx = ctx == null ? Context.newDefault() : ctx;
        return newCtx.with("client.version", (Object)VERSION).with("client.node", (Object)NODE_ID).with("client.id", (Object)this.id);
    }

    private static RpcClient makeRpcClient(GreptimeOptions opts) {
        RpcOptions rpcOpts = opts.getRpcOptions();
        RpcClient rpcClient = RpcFactoryProvider.getRpcFactory().createRpcClient();
        if (!rpcClient.init((Object)rpcOpts)) {
            throw new IllegalStateException("Failed to start the RPC client");
        }
        rpcClient.registerConnectionObserver((RpcClient.ConnectionObserver)new RpcConnectionObserver());
        return rpcClient;
    }

    private static RouterClient makeRouteClient(GreptimeOptions opts) {
        RouterOptions routerOpts = opts.getRouterOptions();
        routerOpts.setRpcClient(GreptimeDB.makeRpcClient(opts));
        RouterClient routerClient = new RouterClient();
        if (!routerClient.init(routerOpts)) {
            throw new IllegalStateException("Failed to start the router client");
        }
        return routerClient;
    }

    private static WriteClient makeWriteClient(GreptimeOptions opts, RouterClient routerClient) {
        WriteOptions writeOpts = opts.getWriteOptions();
        writeOpts.setRouterClient(routerClient);
        WriteClient writeClient = new WriteClient();
        if (!writeClient.init(writeOpts)) {
            throw new IllegalStateException("Failed to start the write client failed");
        }
        return writeClient;
    }

    private static PojoObjectMapper getDefaultPojoObjectMapper() {
        try {
            return (PojoObjectMapper)ServiceLoader.load(PojoObjectMapper.class).first();
        }
        catch (Throwable t) {
            LOG.warn("Failed to load `PojoMapper`, use default: `CachedPojoMapper(1024)`", t);
            return new CachedPojoObjectMapper();
        }
    }

    private static void doGlobalInitializeWorks() {
        SignalHandlersLoader.load();
        RpcServiceRegister.registerAllService();
        MetricsUtil.startScheduledReporter((long)Util.autoReportPeriodMin(), (TimeUnit)TimeUnit.MINUTES);
        Runtime.getRuntime().addShutdownHook(new Thread(MetricsUtil::stopScheduledReporterAndDestroy));
    }

    static {
        GreptimeDB.doGlobalInitializeWorks();
    }

    static final class LogPrinter
    implements Display.Printer {
        private static final int MAX_BUF_SIZE = 8192;
        private final Logger logger;
        private StringBuilder buf = new StringBuilder();

        LogPrinter(Logger logger) {
            this.logger = logger;
        }

        public synchronized Display.Printer print(Object x) {
            this.buf.append(x);
            return this;
        }

        public synchronized Display.Printer println(Object x) {
            this.buf.append(x);
            this.logger.info(this.buf.toString());
            this.truncateBuf();
            this.buf.setLength(0);
            return this;
        }

        private void truncateBuf() {
            if (this.buf.capacity() < 8192) {
                this.buf.setLength(0);
            } else {
                this.buf = new StringBuilder();
            }
        }
    }

    static final class RpcConnectionObserver
    implements RpcClient.ConnectionObserver {
        static final Counter CONN_COUNTER = MetricsUtil.counter((Object)"connection_counter");
        static final Meter CONN_FAILURE = MetricsUtil.meter((Object)"connection_failure");

        RpcConnectionObserver() {
        }

        public void onReady(Endpoint endpoint) {
            CONN_COUNTER.inc();
            MetricsUtil.counter((Object[])new Object[]{"connection_counter", endpoint}).inc();
        }

        public void onFailure(Endpoint endpoint) {
            CONN_COUNTER.dec();
            CONN_FAILURE.mark();
            MetricsUtil.counter((Object[])new Object[]{"connection_counter", endpoint}).dec();
            MetricsUtil.meter((Object[])new Object[]{"connection_failure", endpoint}).mark();
        }

        public void onShutdown(Endpoint endpoint) {
            CONN_COUNTER.dec();
            MetricsUtil.counter((Object[])new Object[]{"connection_counter", endpoint}).dec();
        }
    }
}

